package com.yiboshi.science.utils;

import freemarker.cache.ClassTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import java.io.StringWriter;
import java.util.Map;

public class WordUtils {
    /**
     * 从模板文件生成Word
     *
     * @param outputPath 输出文件路径
     * @throws Exception 转换异常
     */
    public static void getHtmlContent(Object obj, String outputPath) throws Exception {
        Map<String, Object> data1 = HtmlBuilder.obj2Map(obj);
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        cfg.setDefaultEncoding("utf-8");
        cfg.setClassLoaderForTemplateLoading(PdfUtil.class.getClassLoader(), "template");
        cfg.setTemplateLoader(new ClassTemplateLoader(PdfUtil.class.getClassLoader(), "/template"));
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
     
        // 获取模板
        freemarker.template.Template template = cfg.getTemplate("tmp-task.html", "utf-8");
        
        // 处理模板，生成HTML内容
        StringWriter tmpText = new StringWriter();
        template.process(data1, tmpText);
        String htmlContent = tmpText.toString();
        
    }
}
