package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.LogsRequestExceptionDAO;
import com.yiboshi.science.entity.LogsRequestException;
import com.yiboshi.science.param.dto.LogsRequestExceptionDTO;
import com.yiboshi.science.param.query.LogsRequestExceptionQueryVO;
import com.yiboshi.science.service.LogsRequestExceptionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 请求异常日志表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class LogsRequestExceptionServiceImpl extends BaseServiceImpl<LogsRequestExceptionDAO,LogsRequestExceptionQueryVO, LogsRequestExceptionDTO,LogsRequestException> implements LogsRequestExceptionService {

    @Autowired
    private LogsRequestExceptionDAO logsRequestExceptionDAO;

    @Override
    protected void setCriteriaForQuery(LogsRequestExceptionQueryVO vo, QueryWrapper<LogsRequestExceptionQueryVO> criteria) {
        if(Objects.nonNull(vo.getIpAddress())){
            criteria.eq("ip_address", vo.getIpAddress());
        }
        if(Objects.nonNull(vo.getUsername())){
            criteria.eq("username", vo.getUsername());
        }
        if(Objects.nonNull(vo.getRequestCount())){
            criteria.eq("request_count", vo.getRequestCount());
        }
        if(Objects.nonNull(vo.getRequestType())){
            criteria.eq("request_type", vo.getRequestType());
        }
        if (Objects.nonNull(vo.getStartDate()) && Objects.nonNull(vo.getEndDate())){
            criteria.between("created", vo.getStartDate(), vo.getEndDate());
        }
    }

    @Override
    public Pagination<LogsRequestExceptionDTO> getListByPage(LogsRequestExceptionQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<LogsRequestExceptionQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<LogsRequestExceptionDTO> dtoList = logsRequestExceptionDAO.getListByPage(page, criteria).getRecords();
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }
}
