package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectUnitPaymentDAO;
import com.yiboshi.science.entity.ComProjectUnitPayment;
import com.yiboshi.science.param.dto.ComProjectUnitPaymentDTO;
import com.yiboshi.science.param.query.ComProjectUnitPaymentQueryVO;
import com.yiboshi.science.service.ComProjectUnitPaymentService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@AllArgsConstructor
public class ComProjectUnitPaymentServiceImpl extends BaseServiceImpl<ComProjectUnitPaymentDAO, ComProjectUnitPaymentQueryVO, ComProjectUnitPaymentDTO, ComProjectUnitPayment> implements ComProjectUnitPaymentService {

    @Autowired
    private ComProjectUnitPaymentDAO comProjectUnitPaymentDAO;

    @Override
    protected void setCriteriaForQuery(ComProjectUnitPaymentQueryVO vo, QueryWrapper<ComProjectUnitPaymentQueryVO> criteria) {

    }
    public List<ComProjectUnitPaymentDTO> getListByObjectId(String objectId)
    {
        return comProjectUnitPaymentDAO.getListByObjectId(objectId);
    }

    public void deleteByObjectId(String objectId){
        ComProjectUnitPayment model = new ComProjectUnitPayment();
        model.setObjectId(objectId);
        this.delete(model);
    }

    public void insertList(List<ComProjectUnitPaymentDTO> list, String objectId) {
        ComProjectUnitPayment model =new ComProjectUnitPayment();
        model.setObjectId(objectId);
        this.delete(model);
        if (null != list) {
            List<ComProjectUnitPayment> iList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                ComProjectUnitPayment item = convert2Entity(list.get(i));
                item.setObjectId(objectId);
                iList.add(item);
            }
            this.insertBatch(iList);
        }
    }
}
