package com.yiboshi.science.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectSubDAO;
import com.yiboshi.science.entity.ComProjectSub;
import com.yiboshi.science.param.dto.ComProjectSubDTO;
import com.yiboshi.science.param.query.ComProjectSubQueryVO;
import com.yiboshi.science.service.ComProjectSubService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 项目课颖设置表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComProjectSubServiceImpl extends BaseServiceImpl<ComProjectSubDAO, ComProjectSubQueryVO, ComProjectSubDTO, ComProjectSub> implements ComProjectSubService {
    @Autowired
    private ComProjectSubDAO comProjectSubDAO;

    protected void setCriteriaForQuery(ComProjectSubQueryVO vo, QueryWrapper<ComProjectSubQueryVO> criteria) {

    }

    @Override
    public List<ComProjectSubDTO> getListByObjectId(String objectId) {
        return comProjectSubDAO.getListByObjectId(objectId);
    }

    @Override
    public void insertList(List<ComProjectSubDTO> list, String objectId) {
        ComProjectSub file = new ComProjectSub();
        file.setObjectId(objectId);
        this.delete(file);
        if (null != list) {
            for (int i = 0; i < list.size(); i++) {
                if (!isObjectNull(list.get(i))) {
                    list.get(i).setObjectId(objectId);
                    list.get(i).setShowIndex(i + 1);
                    list.get(i).setFileId(list.get(i).getDownloadId());
                    ComProjectSub comProjectSub = convert2Entity(list.get(i));
                    this.insert(comProjectSub);
                }
            }
        }
    }

    @Override
    public void deleteByObjectId(String objectId) {
        ComProjectSub E = new ComProjectSub();
        E.setObjectId(objectId);
        this.delete(E);
    }
}
