package com.yiboshi.science.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectEquipmentDAO;
import com.yiboshi.science.entity.ComProjectEquipment;
import com.yiboshi.science.param.dto.ComProjectEquipmentDTO;
import com.yiboshi.science.param.query.ComProjectEquipmentQueryVO;
import com.yiboshi.science.service.ComProjectEquipmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 设备仪器经费表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComProjectEquipmentServiceImpl extends BaseServiceImpl<ComProjectEquipmentDAO, ComProjectEquipmentQueryVO, ComProjectEquipmentDTO, ComProjectEquipment> implements ComProjectEquipmentService {

    @Autowired
    private ComProjectEquipmentDAO comProjectEquipmentDAO;

    @Override
    protected void setCriteriaForQuery(ComProjectEquipmentQueryVO vo, QueryWrapper<ComProjectEquipmentQueryVO> criteria) {

    }

    @Override
    public List<ComProjectEquipmentDTO> getListByObjectId(String objectId) {
        return comProjectEquipmentDAO.getListByObjectId(objectId);
    }

    @Override
    public void insertEquipmentList(List<ComProjectEquipmentDTO> budgetList, String objectId) {
        ComProjectEquipment E =new ComProjectEquipment();
        E.setObjectId(objectId);
        this.delete(E);
        if (null != budgetList) {
            budgetList.forEach((e) -> {
                if (!isObjectNull(e)) {
                    e.setObjectId(objectId);
                    ComProjectEquipment comProjectBudget = convert2Entity(e);
                    this.insert(comProjectBudget);
                }
            });
//            budgetList.forEach(e -> e.setObjectId(objectId));
//            List<ComProjectEquipment> list = convertDto2EntityList(budgetList);
//            this.insertBatch(list);
        }
    }

    @Override
    public void deleteByObjectId(String objectId) {
        ComProjectEquipment E =new ComProjectEquipment();
        E.setObjectId(objectId);
        this.delete(E);
    }
}
