package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComTalentGroupDetail;
import com.yiboshi.science.param.dto.ComTalentGroupDetailDTO;
import com.yiboshi.science.param.query.ComTalentGroupDetailQueryVO;

import java.util.List;

/**
 * 人才分组明细表
 */
public interface ComTalentGroupDetailService extends BaseService<ComTalentGroupDetailQueryVO, ComTalentGroupDetailDTO, ComTalentGroupDetail> {

    ComTalentGroupDetailDTO getTalentGroupDetailByGP(String groupId, String talentId);

    List<ComTalentGroupDetailDTO> getTalentDetailList(String groupId);

    List<ComTalentGroupDetailDTO> getTalentDetailList2(String groupId);

    Pagination<ComTalentGroupDetailDTO> getTalentDetailListbyPage(ComTalentGroupDetailQueryVO vo);

    List<ComTalentGroupDetailDTO> getTalentListByGroupIds(List<String> groupIds);
    List<ComTalentGroupDetailDTO> getMembersListByGroupIds(List<String> groupIds);
}
