package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectSub;
import com.yiboshi.science.param.dto.ComProjectSubDTO;
import com.yiboshi.science.param.query.ComProjectSubQueryVO;

import java.util.List;

/**
 * 项目课颖设置表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectSubService extends BaseService<ComProjectSubQueryVO, ComProjectSubDTO, ComProjectSub> {
    /** 获取列表
     *
     * @param objectId
     * @return
     */
    List<ComProjectSubDTO> getListByObjectId(String objectId);
    /** 插入列表
     *
     * @param list
     * @param objectId
     */
    void insertList(List<ComProjectSubDTO> list, String objectId);
    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId);
}
