package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComProjectGroup;
import com.yiboshi.science.param.dto.ComProjectGroupDTO;
import com.yiboshi.science.param.dto.ComProjectKnowledgeStatisticDTO;
import com.yiboshi.science.param.query.ComProjectAuditQueryVO;
import com.yiboshi.science.param.query.ComProjectGroupQueryVO;

import java.util.List;
import java.util.Map;

public interface ComProjectGroupService extends BaseService<ComProjectGroupQueryVO, ComProjectGroupDTO, ComProjectGroup> {

    void processProjectGroup(String ProjectID);

    Pagination<ComProjectGroupDTO>  getProjectGroupListByPage(ComProjectGroupQueryVO vo);

    boolean updataProjectGroupAdjust(List<String> IdList, String groupId);

    ComProjectGroupDTO getGroupById(String id);

    String save(ComProjectGroupDTO group);

    String deleteByGroupId(String id);

    void CalculateGroupProjectCount(String groupId);

    void CalculateGroupExpertCount(String groupId);

    String assignProjectGroup(int systemType, List<String> GroupList, List<String> ExpertList);

    String deleteAssignGroupExpert(String id);

    boolean InsertProjectGroup(List<String> IdList, String groupId);

    void processGroupProjectExpert(String groupId);

    boolean deleteGroupProjectExpert(String groupId, String projId);

    List<ComProjectKnowledgeStatisticDTO> getProjectKnowledgeStatisticByGroupId(String groupId);

    boolean addProjectGroupKnowledge(String groupId, List<String> KnowledgeList, ComProjectAuditQueryVO vo);

    boolean deleteProjectGroupKnowledge(String groupId, String knowledgeId);

    boolean deleteProjectGroupDetail(String groupId, String knowledgeId);
    Map<String, Object> getGroupProjectInfo(List<String> groupIds);
}
