package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComPerson;
import com.yiboshi.science.param.dto.ComPersonDTO;
import com.yiboshi.science.param.dto.ComTalentApplyDTO;
import com.yiboshi.science.param.dto.DataStatisticsDTO;
import com.yiboshi.science.param.dto.UserImportDTO;
import com.yiboshi.science.param.query.ComPersonQueryVO;

import java.io.IOException;
import java.util.List;

/**
 * 人员表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComPersonService extends BaseService<ComPersonQueryVO, ComPersonDTO, ComPerson> {
    /**
     * 多表分页查询
     *
     * @param vo 查询条件
     * @return 分页对象
     */
    Pagination<ComPersonDTO> getAllListByPage(ComPersonQueryVO vo);
    /**
     * 人员注册
     *
     * @param dto
     * @return
     */
    String register(ComPersonDTO dto);

    /**
     * 人员审核
     *
     * @param dto
     * @return
     */
    String audit(ComPersonDTO dto);
    /**
     * 根据远程人员id获取人员信息
     *
     * @param id 远程人员id
     * @return
     */
    ComPerson getPersonInfoByLongId(Long id);
    /**
     * 根据id获取人员信息
     *
     * @param id 人员id
     * @return
     */
    ComPersonDTO getPersonById(String id);
    /**
     * 根据证件号获取人员
     *
     * @param certId 值
     * @return
     */
    ComPerson getPersonByCertId(String certId);
    /**
     * 功能:修改人员信息
     *
     * @param d 输入值
     */
    String updatePerson(ComPersonDTO d);
    /**
     * 功能:修改人员状态
     *
     * @param id 输入值
     */
    String updateState(String id, Integer personState);
    /**
     * 功能:根据单位id获取单位管理员
     *
     * @param unitId 输入值
     */
    List<ComPersonDTO> getManagerListByUnitId(String unitId);
    /**
     * 验证证件号是否存在
     *
     * @param value 值
     * @return
     */
    Boolean isCertIdExist(String value,String id);
    /**
     * 验证手机号是否存在
     *
     * @param value 值
     * @return
     */
    Boolean isMobileExist(String value);
    /**
     * 获取用户
     */
    void getUserFromRemoteServer();
    /**
     * 导入
     *
     * @param list
     * @return
     */
    List<UserImportDTO> userImport(List<UserImportDTO> list) throws IOException;
    DataStatisticsDTO getRegisterPersonCount(ComPersonQueryVO v);
    DataStatisticsDTO getRegisterPersonCountByDay(ComPersonQueryVO v);

    boolean isComplete(ComPerson person);

    String insertOrUpdate(ComTalentApplyDTO dto);
}
