package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.config.security.SecurityUserHolder;
import com.yiboshi.science.enumeration.CommonEnum;
import com.yiboshi.science.param.dto.*;
import com.yiboshi.science.param.query.ComPersonQueryVO;
import com.yiboshi.science.param.query.ComProjectAuditQueryVO;
import com.yiboshi.science.param.query.ComUnitQueryVO;
import com.yiboshi.science.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;


/**
 * /**
 *
 * @author wxl
 * @date
 */
@Slf4j
@RestController
@RequestMapping("/v1/science-admin/statistical")
@RequiredArgsConstructor
@Api(tags = "statistical", description = "系统数据统计接口")
public class StatisticalController {

    @Autowired
    private ComProjectAuditService comProjectAuditService;

    @Autowired
    private ComBatchService comBatchService;

    @Autowired
    private ComUnitService comUnitService;

    @Autowired
    private ComPersonService comPersonService;

    @Autowired
    private LogsLoginService logsLoginService;

    @Autowired
    private ComDownloadService ComDownloadService;

    /**
     * 获取统计数据
     */
    @ApiOperation(value = "获取统计数据", httpMethod = "GET", notes = "获取统计数据")
    @GetMapping
    @RequestMapping("/geFirstAuditCount")
    @PreAuthorize("hasAnyRole('GOV','UNIT')")
    public ResponseDataModel<DataStatisticsDTO> geFirstAuditCount(ComProjectAuditQueryVO v) {
        v.setAuditUnitId(SecurityUserHolder.getUnitId());
        v.setAuditMethod(CommonEnum.auditMethod.audit.getCode());
        return getDataStatisticsDTOResponseDataModel(v);
    }
    /**
     * 获取统计数据
     */
    @ApiOperation(value = "获取统计数据", httpMethod = "GET", notes = "获取统计数据")
    @GetMapping
    @RequestMapping("/geLastAuditCount")
    @PreAuthorize("hasAnyRole('GOV')")
    public ResponseDataModel<DataStatisticsDTO> geLastAuditCount(ComProjectAuditQueryVO v) {
        v.setAuditUnitId(SecurityUserHolder.getUnitId());
        v.setAuditMethod(CommonEnum.auditMethod.last.getCode());
        v.setCompleted(1);
        return getDataStatisticsDTOResponseDataModel(v);
    }
    private ResponseDataModel<DataStatisticsDTO> getDataStatisticsDTOResponseDataModel(ComProjectAuditQueryVO v) {
        DataStatisticsDTO count= comProjectAuditService.getCount(v);
        DataStatisticsDTO dto=new DataStatisticsDTO();
        dto.setCount1(count.getCount1());
        dto.setCount2(count.getCount5()-count.getCount1());
        dto.setCount5(count.getCount5());
        dto.setCount3(comProjectAuditService.getCountByDay(v).getCount1());
        return ResponseDataModel.ok(dto);
    }
    /**
     * 获取统计数据
     */
    @ApiOperation(value = "获取统计数据", httpMethod = "GET", notes = "获取统计数据")
    @GetMapping
    @RequestMapping("/getFirstAuditPassCount")
    @PreAuthorize("hasAnyRole('GOV')")
    public ResponseDataModel<DataStatisticsDTO> getFirstAuditPassCount(ComProjectAuditQueryVO v) {
        v.setAuditUnitId(SecurityUserHolder.getUnitId());
        v.setAuditUnitId(SecurityUserHolder.getUnitId());
        v.setAuditResult(CommonEnum.auditResult.pass.getCode());
        v.setAuditMethod(CommonEnum.auditMethod.audit.getCode());
        DataStatisticsDTO count= comProjectAuditService.getFirstAuditPassCount(v);
        return ResponseDataModel.ok(count);
    }

    @ApiOperation(value = "科研项目分配人次", httpMethod = "GET", notes = "科研项目分配人次")
    @GetMapping
    @RequestMapping("/getAssignPersonCount")
    @PreAuthorize("hasAnyRole('GOV')")
    public ResponseDataModel<DataStatisticsDTO> getAssignPersonCount(Integer systemType) {
        Integer assignYear = comBatchService.getReportYear(systemType, null);
        return ResponseDataModel.ok(comProjectAuditService.getAssignPersonCount(assignYear, systemType));
    }

    /**
     * 获取统计数据
     */
    @ApiOperation(value = "获取统计数据", httpMethod = "GET", notes = "获取统计数据")
    @GetMapping
    @RequestMapping("/getLoginCount")
    @PreAuthorize("hasAnyRole('GOV','ADMIN')")
    public ResponseDataModel<DataStatisticsDTO> getLoginCount() {
        DataStatisticsDTO count=logsLoginService.getCount();
        count.setCount3(logsLoginService.getCountByDay().getCount1());
        return ResponseDataModel.ok(count);
    }
    @ApiOperation(value = "获取统计数据", httpMethod = "GET", notes = "获取统计数据")
    @GetMapping
    @RequestMapping("/getDirectorySize")
    @PreAuthorize("hasAnyRole('ADMIN')")
    public ResponseDataModel<String> getDirectorySize() {
        return ResponseDataModel.ok(ComDownloadService.getDirectorySize());
    }

    /**
     * 获取统计数据
     */
    @ApiOperation(value = "获取统计数据", httpMethod = "GET", notes = "获取统计数据")
    @GetMapping
    @RequestMapping("/getRegisterUnitCount")
    @PreAuthorize("hasAnyRole('GOV')")
    public ResponseDataModel<DataStatisticsDTO> getRegisterUnitCount() {
        ComUnitQueryVO vo=new ComUnitQueryVO();
        vo.setAuditResult(0);
        vo.setTreeCode(SecurityUserHolder.getUnitCode());
        DataStatisticsDTO count=comUnitService.getRegisterUnitCount(vo);
        count.setCount3(comUnitService.getRegisterUnitCountByDay(vo).getCount1());
        return ResponseDataModel.ok(count);
    }

    /**
     * 获取统计数据
     */
    @ApiOperation(value = "获取统计数据", httpMethod = "GET", notes = "获取统计数据")
    @GetMapping
    @RequestMapping("/getRegisterPersonCount")
    @PreAuthorize("hasAnyRole('UNIT')")
    public ResponseDataModel<DataStatisticsDTO> getRegisterPersonCount() {
        ComPersonQueryVO vo=new ComPersonQueryVO();
        vo.setAuditUnit(SecurityUserHolder.getUnitId());
        vo.setAuditResult(0);
        DataStatisticsDTO count=comPersonService.getRegisterPersonCount(vo);
        count.setCount3(comPersonService.getRegisterPersonCountByDay(vo).getCount1());
        return ResponseDataModel.ok(count);
    }

    /**
     * 获取统计数据
     */
    @ApiOperation(value = "获取统计数据", httpMethod = "GET", notes = "获取统计数据")
    @GetMapping
    @RequestMapping("/getTreeCodeProjectCount")
    @PreAuthorize("hasAnyRole('GOV','UNIT')")
    public ResponseDataModel<List<DataStatisticsDTO>> getTreeCodeProjectCount(ComProjectAuditQueryVO v) {
        v.setAuditUnitId(SecurityUserHolder.getUnitId());
        if(Objects.nonNull(v.getSystemType())){
            if(v.getSystemType().equals(CommonEnum.systemType.key.getCode()))
                v.setAuditMethod(CommonEnum.auditMethod.audit.getCode());
            else
                v.setAuditMethod(CommonEnum.auditMethod.last.getCode());
        }
        List<DataStatisticsDTO> list= comProjectAuditService.getTreeCodeProjectCount(v,SecurityUserHolder.getUnitCode());
        return ResponseDataModel.ok(list);
    }
    /**
     * 获取统计数据
     */
    @ApiOperation(value = "获取统计数据", httpMethod = "GET", notes = "获取统计数据")
    @GetMapping
    @RequestMapping("/getKnowledgeCount")
    @PreAuthorize("hasAnyRole('GOV','UNIT')")
    public ResponseDataModel<List<DataStatisticsDTO>> getKnowledgeCount(ComProjectAuditQueryVO v) {
        v.setAuditUnitId(SecurityUserHolder.getUnitId());
        if(Objects.nonNull(v.getSystemType())){
            if(v.getSystemType().equals(CommonEnum.systemType.key.getCode()))
                v.setAuditMethod(CommonEnum.auditMethod.audit.getCode());
            else
                v.setAuditMethod(CommonEnum.auditMethod.last.getCode());
        }
        List<DataStatisticsDTO> list= comProjectAuditService.getKnowledgeCount(v);
        return ResponseDataModel.ok(list);
    }

    /**
     *
     * @param v
     * @return
     */
    @ApiOperation(value = "获取统计数据", httpMethod = "GET", notes = "获取统计数据")
    @GetMapping
    @RequestMapping("/getKnowledgeStatistic")
    @PreAuthorize("hasAnyRole('GOV')")
    public ResponseDataModel<List<KnowledgeStatisticsDTO>> getKnowledgeStatistic(ComProjectAuditQueryVO v) {
        v.setAuditUnitId(SecurityUserHolder.getUnitId());
        if (Objects.nonNull(v.getSystemType())) {
            if (v.getSystemType().equals(CommonEnum.systemType.key.getCode()))
                v.setAuditMethod(CommonEnum.auditMethod.audit.getCode());
            else
                v.setAuditMethod(CommonEnum.auditMethod.last.getCode());
        }
        List<KnowledgeStatisticsDTO> list= comProjectAuditService.getKnowledgeStatistic(v);
        return ResponseDataModel.ok(list);
    }

    @ApiOperation(value = "项目组二级学科选中列表", httpMethod = "GET", notes = "项目组二级学科选中列表")
    @GetMapping
    @RequestMapping("/getKnowledgeSelectedList")
    @PreAuthorize("hasAnyRole('GOV')")
    public ResponseDataModel<List<KnowledgeStatisticsDTO>> getKnowledgeSelectedList(ComProjectAuditQueryVO v) {
        v.setAuditUnitId(SecurityUserHolder.getUnitId());
        if (Objects.nonNull(v.getSystemType())) {
            if (v.getSystemType().equals(CommonEnum.systemType.key.getCode()))
                v.setAuditMethod(CommonEnum.auditMethod.audit.getCode());
            else
                v.setAuditMethod(CommonEnum.auditMethod.last.getCode());
        }
        List<KnowledgeStatisticsDTO> list= comProjectAuditService.getKnowledgeSelectedList(v);
        return ResponseDataModel.ok(list);
    }

    @ApiOperation(value = "项目专家组分配统计列表", httpMethod = "GET", notes = "项目专家组分配统计列表")
    @GetMapping
    @RequestMapping("/getProjectExpertGroupStatistic")
    @PreAuthorize("hasAnyRole('GOV')")
    public ResponseDataModel<List<projectExpertGroupStatisticDTO>> getProjectExpertGroupStatistic(ComProjectAuditQueryVO vo) {
        vo.setAuditUnitId(SecurityUserHolder.getUnitId());
        vo.setSystemType(SecurityUserHolder.projectType());
        vo.setAuditType(1);
        vo.setAuditMethod(CommonEnum.auditMethod.last.getCode());
        return ResponseDataModel.ok(comProjectAuditService.getProjectExpertGroupStatistic(vo));
    }

    @ApiOperation(value = "项目评审结果统计", httpMethod = "GET", notes = "项目评审结果统计")
    @GetMapping
    @RequestMapping("/getEvaluationStatistic")
    @PreAuthorize("hasAnyRole('GOV')")
    public ResponseDataModel<List<EvaluationStatisticDTO>> getEvaluationStatistic(Integer reportYear) {
        return ResponseDataModel.ok(comProjectAuditService.getEvaluationStatistic(reportYear));
    }

    @ApiOperation(value = "导出excel数据列表", httpMethod = "GET", notes = "导出excel数据列表")
    @GetMapping
    @RequestMapping("/getEvaluationExportExcel")
    @PreAuthorize("hasAnyRole('GOV')")
    public ResponseDataModel<EvaluationExportExcelDTO> getEvaluationExportExcel(Integer reportYear, Integer startRow, String rowMarks) {
        String[] split = rowMarks.split(",");
        List<String> rowMarkList = Arrays.asList(split);

        return ResponseDataModel.ok(comProjectAuditService.getEvaluationExportExcel(reportYear, startRow, rowMarkList));
    }

    @ApiOperation(value = "导出excel数据列表", httpMethod = "GET", notes = "导出excel数据列表")
    @GetMapping
    @RequestMapping("/getProjectGroupScoreOrder")
    @PreAuthorize("hasAnyRole('GOV')")
    public ResponseDataModel<EvaluationExportExcelDTO> getProjectGroupScoreOrder(Integer reportYear, Integer startRow, String rowMarks) {
        String[] split = rowMarks.split(",");
        List<String> rowMarkList = Arrays.asList(split);

        return ResponseDataModel.ok(comProjectAuditService.getProjectGroupScoreOrder(reportYear, startRow, rowMarkList));
    }

    @ApiOperation(value = "导出excel数据列表", httpMethod = "GET", notes = "导出excel数据列表")
    @GetMapping
    @RequestMapping("/getTalentEvaluationStatistic")
    @PreAuthorize("hasAnyRole('GOV')")
    public ResponseDataModel<TalentEvaluationExportExcelDTO> getTalentEvaluationStatistic(Integer reportYear, Integer startRow, String rowMarks) {
        String[] split = rowMarks.split(",");
        List<String> rowMarkList = Arrays.asList(split);

        return ResponseDataModel.ok(comProjectAuditService.getTalentEvaluationStatistic(reportYear, startRow, rowMarkList));
    }

    @ApiOperation(value = "导出excel数据列表", httpMethod = "GET", notes = "导出excel数据列表")
    @GetMapping
    @RequestMapping("/getTalentGroupScoreOrder")
    @PreAuthorize("hasAnyRole('GOV')")
    public ResponseDataModel<TalentEvaluationExportExcelDTO> getTalentGroupScoreOrder(Integer reportYear, Integer startRow, String rowMarks) {
        String[] split = rowMarks.split(",");
        List<String> rowMarkList = Arrays.asList(split);

        return ResponseDataModel.ok(comProjectAuditService.getTalentGroupScoreOrder(reportYear, startRow, rowMarkList));
    }
}
