package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.LogsLogin;
import com.yiboshi.science.param.dto.LogsLoginDTO;
import com.yiboshi.science.param.query.LogsLoginQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.LogsLoginService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 功能：登录日志表 接口
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "logs-login",description = "登录日志表")
@RestController
@RequestMapping("/v1/science-admin/logs-login")
public class LogsLoginController extends BaseController<LogsLoginService,LogsLoginQueryVO, LogsLoginDTO, LogsLogin> {

    @Autowired
    private LogsLoginService logsLoginService;

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getListByPage")
    public ResponseDataModel<Pagination<LogsLoginDTO>> getListByPage(@Validated LogsLoginQueryVO vo, BindingResult bindingResult) {
        Pagination<LogsLoginDTO> page = logsLoginService.getListByPage(vo);
        return ResponseDataModel.ok(page);
    }
}
