package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComTalentGroupAssign;
import com.yiboshi.science.param.dto.ComTalentGroupAssignDTO;
import com.yiboshi.science.param.query.ComTalentGroupAssignQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComTalentGroupAssignService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "com-talent-group-assign", description = "人才分组分配表")
@RestController
@RequestMapping("/v1/science-admin/com-talent-group-assign")
public class ComTalentGroupAssignController extends BaseController<ComTalentGroupAssignService, ComTalentGroupAssignQueryVO, ComTalentGroupAssignDTO, ComTalentGroupAssign> {

    @Autowired
    private ComTalentGroupAssignService comTalentGroupAssignService;

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getListByPage")
    public ResponseDataModel<Pagination<ComTalentGroupAssignDTO>> getListByPage(@Validated ComTalentGroupAssignQueryVO vo, BindingResult bindingResult) {
        Pagination<ComTalentGroupAssignDTO> page = comTalentGroupAssignService.getListByPage(vo);
        return ResponseDataModel.ok(page);
    }

    @ApiOperation(value = "根据人才分组Id获取专家明细", httpMethod = "GET", notes = "根据人才分组Id获取专家明细")
    @GetMapping
    @RequestMapping("/getAssignExpertList")
    public ResponseDataModel<List<ComTalentGroupAssignDTO>> getAssignExpertList(String groupId) {
        return ResponseDataModel.ok(comTalentGroupAssignService.getAssignExpertList(groupId));
    }

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getAssignGroupExpertById")
    public ResponseDataModel<ComTalentGroupAssignDTO> getAssignGroupExpertById(String id) {
        return ResponseDataModel.ok(comTalentGroupAssignService.getAssignGroupExpertById(id));
    }
}
