package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 查询任务书预期成果表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询任务书预期成果表VO")
public class ComTaskTargetQueryVO extends PaginationVO{
    /** id */
    @ApiModelProperty(value = "")
    private String id;
    /** 任务书Id */
    @ApiModelProperty(value = "任务书Id")
    private String testId;
    /** 预期成果Id (参数表获取) */
    @ApiModelProperty(value = "预期成果Id (参数表获取)", position = 1)
    private String targetId;
    /** 预期成果 */
    @ApiModelProperty(value = "预期成果", position = 2)
    private String result;
    /** 数量 */
    @ApiModelProperty(value = "数量", position = 3)
    private Integer resultCount;
}