package com.yiboshi.science.param.query;

import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "人才分组明细表VO")
public class ComTalentGroupDetailQueryVO extends PaginationVO {

    /** 人才分组Id */
    @ApiModelProperty(value = "人才分组Id", position = 1)
    @Length(max=36, message = "人才分组Id不能大于36")
    private String groupId;

    /** 人才Id */
    @ApiModelProperty(value = "人才Id", position = 2)
    @Length(max=36, message = "人才Id不能大于36")
    private String talentId;

    /** 备注 */
    @ApiModelProperty(value = "备注", position = 3)
    @Length(max=500, message = "备注不能大于500")
    private String remark;

    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 3)
    private String personName;

    /** 证件号 */
    @ApiModelProperty(value = "证件号", position = 3)
    private String certId;

    /** 二级学科Id */
    @ApiModelProperty(value = "二级学科Id", position = 6)
    private String knowledgeParentId;

    /** 学科Id */
    @ApiModelProperty(value = "学科Id", position = 7)
    @Length(max=36, message = "学科Id不能大于36")
    private String knowledgeId;
}
