package com.yiboshi.science.param.query;

import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 单位支出明细预算表VO
 * 
 * @author xujun
 * @version 2024-11-28
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "单位支出明细预算表VO")
public class ComProjectUnitPaymentQueryVO extends PaginationVO{

    /** 对象id（项目Id/任务书Id） */
    @ApiModelProperty(value = "对象id（项目Id/任务书Id）", position = 2)
    @Length(max=36, message = "对象id（项目Id/任务书Id）不能大于36")
    private String objectId;
    /** 单位名称 */
    @ApiModelProperty(value = "单位名称", position = 2)
    @Length(max=100, message = "单位名称不能大于100")
    private String unitName;
    /** 单位国别 */
    @ApiModelProperty(value = "单位国别", position = 2)
    @Length(max=100, message = "单位国别不能大于100")
    private String countryName;
    /** 统一社会信用代码 */
    @ApiModelProperty(value = "统一社会信用代码", position = 2)
    @Length(max=50, message = "统一社会信用代码不能大于50")
    private String socialCode;
    /** 单位类型Id */
    @ApiModelProperty(value = "单位类型Id", position = 2)
    @Length(max=36, message = "单位类型Id不能大于36")
    private String unitRole;
    /** 任务分工 */
    @ApiModelProperty(value = "任务分工", position = 2)
    @Length(max=300, message = "任务分工不能大于300")
    private String taskDivision;
    /** 研究任务负责人 */
    @ApiModelProperty(value = "研究任务负责人", position = 2)
    @Length(max=60, message = "研究任务负责人不能大于60")
    private String taskLeader;

    /** 间接费用(省级财政资金) */
    @ApiModelProperty(value = "间接费用(省级财政资金)", position = 3)
    private BigDecimal indirectFee;
    /** 小计金额(省级财政资金) */
    @ApiModelProperty(value = "小计金额(省级财政资金)", position = 3)
    private BigDecimal fundAmount;

    /** 自筹资金(单位自筹资金) */
    @ApiModelProperty(value = "自筹资金(单位自筹资金)", position = 3)
    private BigDecimal selfAmount;
    /** 总金额 */
    @ApiModelProperty(value = "总金额", position = 3)
    private BigDecimal totalAmount;
}