package com.yiboshi.science.param.query;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "单位管理员表VO")
public class ComManagerQueryVO extends PaginationVO {
    /** 人员Id */
    @ApiModelProperty(value = "人员Id", position = 2)
    @Length(max=36, message = "人员Id不能大于36")
    private String personId;
    /** 状态  1 启用  2 停用 */
    @ApiModelProperty(value = "状态  1 启用  2 停用", position = 3 )
    private Integer state;

    /** 证件号 */
    @ExcelProperty("证件号")
    @ApiModelProperty(value = "证件号", position = 5)
    @Length(max=18, message = "证件号不能大于18")
    private String certId;
    /** 姓名 */
    @ExcelProperty("姓名")
    @ApiModelProperty(value = "姓名", position = 6)
    private String personName;
    /** 性别 */
    @ExcelProperty("性别")
    @ApiModelProperty(value = "性别", position = 7)
    private String sex;
    /** 出生日期 */
    @ApiModelProperty(value = "出生日期", position = 8)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;
    /** 职称Id */
    @ApiModelProperty(value = "职称Id", position = 9)
    @Length(max=36, message = "职称Id不能大于36")
    private String title;
    /** 专业Id */
    @ApiModelProperty(value = "专业Id", position = 11)
    @Length(max=36, message = "专业Id不能大于36")
    private String spec;
    /** 学位Id */
    @ApiModelProperty(value = "学位Id", position = 13 )
    @Length(max=36, message = "学位Id不能大于36")
    private String degree;
    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", position = 15)
    private String email;
    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 16)
    private String mobile;
    /** 照片Id */
    @ApiModelProperty(value = "照片Id", position = 17)
    @Length(max=36, message = "照片Id不能大于36")
    private String photo;
    /** 单位Id */
    @ApiModelProperty(value = "单位Id", position = 7)
    private String unitId;
    /** 单位 */
    @ApiModelProperty(value = "单位", position = 20)
    private String unitName;
    /** 用户名 */
    @ApiModelProperty(value = "用户名", position = 22)
    private String username;

    /** 角色Id */
    @ApiModelProperty(value = "角色Id", position = 7)
    private String roleId;
}
