package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 任务书表DTO
 *
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "任务书表DTO")
public class ComProjectTaskDTO extends BaseDTO {
    /** 项目Id */
    @ApiModelProperty(value = "项目Id", position = 1 )
    @Length(max=36, message = "项目Id不能大于36")
    private String projId;
    /** 年度 */
    @ApiModelProperty(value = "年度", position = 2 )
    private Integer reportYear;
    /** 合同书状态  0 未 填,-10 起 草, 10 待提交,20 审核中,30 返回修改，40 审核不通过， 50 审核通过*/
    @ApiModelProperty(value = "合同书状态  0 未 填,-10 起 草, 10 待提交,20 审核中,30 返回修改，40 审核不通过， 50 审核通过", position = 3 )
    private Integer taskState;
    /** 开始日期 */
    @ApiModelProperty(value = "开始日期", position = 7 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /** 结束日期 */
    @ApiModelProperty(value = "结束日期", position = 8 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    /** 注册单位类型 */
    @ApiModelProperty(value = "注册单位类型", position = 1 )
    @Length(max=50, message = "注册单位类型不能大于50")
    private String unitType;
    /** 组织机构代码/统一社会信用代码 */
    @ApiModelProperty(value = "组织机构代码/统一社会信用代码", position = 1 )
    @Length(max=50, message = "组织机构代码/统一社会信用代码不能大于50")
    private String organizationCode;
    /** 通讯地址 */
    @ApiModelProperty(value = "通讯地址", position = 1)
    @Length(max=200, message = "通讯地址不能大于200")
    private String unitAddress;
    /** 注册所在地 */
    @ApiModelProperty(value = "注册所在地", position = 1 )
    @Length(max=50, message = "注册所在地不能大于50")
    private String registeredAddress;
    /** 邮编 */
    @ApiModelProperty(value = "邮编", position = 1 )
    @Length(max=10, message = "邮编不能大于10")
    private String postCode;
    /** 法定代表人 */
    @ApiModelProperty(value = "法定代表人", position = 1 )
    @Length(max=50, message = "法定代表人不能大于50")
    private String legalPerson;
    /** 职工总数 */
    @ApiModelProperty(value = "职工总数", position = 1 )
    private Integer workforce;
    /** 其中专科以上人员 */
    @ApiModelProperty(value = "其中专科以上人员", position = 1 )
    private Integer specializedPersonnel;
    /** 研究开发人员 */
    @ApiModelProperty(value = "研究开发人员", position = 1 )
    private Integer researchPersonnel;
    /** 开户银行 */
    @ApiModelProperty(value = "开户银行", position = 1 )
    @Length(max=100, message = "开户银行不能大于100")
    private String depositBank;
    /** 银行账号 */
    @ApiModelProperty(value = "银行账号", position = 1 )
    @Length(max=50, message = "银行账号不能大于50")
    private String bankAccount;
    /** 开户银行地址 */
    @ApiModelProperty(value = "开户银行地址", position = 1 )
    @Length(max=100, message = "开户银行地址不能大于100")
    private String depositBankAddress;
    /** 银行联行号 */
    @ApiModelProperty(value = "银行联行号", position = 1 )
    @Length(max=50, message = "银行联行号不能大于50")
    private String interbankNumber;
    /** 所属我省重点领域 */
    @ApiModelProperty(value = "所属我省重点领域", position = 13 )
    @Length(max=50, message = "所属我省重点领域不能大于50")
    private String keyAreas;
    /** 电话 */
    @ApiModelProperty(value = "职务", position = 9 )
    @Length(max=36, message = "职务不能大于36")
    private String telephone;
    /** 传真 */
    @ApiModelProperty(value = "职务", position = 9 )
    @Length(max=36, message = "职务不能大于36")
    private String fax;
    /** 项目分工 */
    @ApiModelProperty(value = "项目分工", position = 8 )
    @Length(max=300, message = "项目分工不能大于300")
    private String projWork;
    /** 项目联系人姓名 */
    @ApiModelProperty(value = "项目联系人姓名", position = 16)
    @Length(max=100, message = "项目联系人姓名不能大于100")
    private String linkName;
    /** 联系人手机 */
    @ApiModelProperty(value = "联系人手机", position = 16)
    @Length(max=50, message = "联系人手机不能大于50")
    private String linkMobile;
    /** 传真 */
    @ApiModelProperty(value = "传真", position = 16)
    @Length(max=100, message = "传真不能大于100")
    private String linkFax;
    /** 电子邮箱 */
    @ApiModelProperty(value = "电子邮箱", position = 16)
    @Length(max=100, message = "电子邮箱不能大于100")
    private String linkEmail;
    /** 是否科技报告 0 否 1 是 */
    @ApiModelProperty(value = "是否科技报告", position = 1 )
    private Integer isTechnologyReport;
    /** 立项报告 */
    @ApiModelProperty(value = "立项报告", position = 2 )
    private Integer projectReport;
    /** 进展报告 */
    @ApiModelProperty(value = "进展报告", position = 2 )
    private Integer progressReport;
    /** 专题报告 */
    @ApiModelProperty(value = "专题报告", position = 2 )
    private Integer specialReport;
    /** 最终报告 */
    @ApiModelProperty(value = "最终报告", position = 2 )
    private Integer finalReport;

    /** 单位是否审核通过 0 否 1 通过 */
    @ApiModelProperty(value = "单位是否审核通过 0 否 1 通过", position = 1 )
    private Integer isUnitAuditPass;

    /** 合同书状态  0 未 填,-10 起 草, 10 待提交,20 审核中,30 返回修改，40 审核不通过， 50 审核通过*/
    private String taskStateName;

    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    private String projName;
    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 2 )
    private String projNo;
    /** 项目类型 */
    @ApiModelProperty(value = "项目类型", position = 3 )
    private Integer systemType;
    /** 项目开始时间 */
    @ApiModelProperty(value = "项目开始时间", position = 10 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date projStart;
    /** 项目结束时间 */
    @ApiModelProperty(value = "项目结束时间", position = 11 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date projEnd;
    /** 项目实施目标 */
    @ApiModelProperty(value = "项目实施目标", position = 28 )
    private String researchContent;
    /** 主要技术指标 */
    @ApiModelProperty(value = "主要技术指标", position = 35 )
    private String technologyTarget;
    /** 主要经济指标 */
    @ApiModelProperty(value = "主要经济指标", position = 35 )
    private String economyTarget;
    /** 项目实施中形成的示范基地、中试线、生产线及其规模等 */
    @ApiModelProperty(value = "项目实施中形成的示范基地、中试线、生产线及其规模等", position = 35 )
    private String achievementTarget;
    /** 科技报告考核指标 */
    @ApiModelProperty(value = "科技报告考核指标", position = 35 )
    private String technologyReportsTarget;
    /** 其他应考核的指标 */
    @ApiModelProperty(value = "其他应考核的指标", position = 35 )
    private String otherTarget;
    /** 合同书(附件Id) */
    @ApiModelProperty(value = "合同书(附件Id)", position = 1 )
    @Length(max=150, message = "合同书(附件Id)不能大于36")
    private String contract;

    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 1 )
    private String contractId;
    /** 附件名 */
    @ApiModelProperty(value = "附件名", position = 6)
    private String contractName;
    /** URL */
    @ApiModelProperty(value = "URL", position = 7)
    private String contractUrl;

    /** 项目总经费(万元） */
    @ApiModelProperty(value = "项目总经费(万元）", position = 39)
    private BigDecimal totalFunding;
    /** 申请科技经费(万元) */
    @ApiModelProperty(value = "申请科技经费(万元)", position = 40)
    private BigDecimal govFunding;
    /** 自筹 */
    @ApiModelProperty(value = "自筹", position = 42)
    private BigDecimal selfFunding;
    /** 其他 */
    @ApiModelProperty(value = "其他", position = 43)
    private BigDecimal otherFunding;

    /** 单位id */
    @ApiModelProperty(value = "单位id", position = 41)
    private String appUnitId;
    /** 单位名称 */
    @ApiModelProperty(value = "单位名称", position = 41)
    private String appUnitName;
    /** 注册单位类型 */
    @ApiModelProperty(value = "注册单位类型", position = 12)
    private String unitTypeName;

    /** 人员Id */
    @ApiModelProperty(value = "人员Id", position = 41)
    private String appPersonId;
    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 41)
    private String appPersonName;
    /** 性别 */
    @ApiModelProperty(value = "性别", position = 3)
    private String sex;
    /** 出生年月 */
    @ApiModelProperty(value = "出生年月", position = 3)
    private Date birthday;
    /** 证件号 */
    @ApiModelProperty(value = "证件号", position = 3)
    private String certId;
    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", position = 15)
    private String email;
    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 16)
    private String mobile;
    /** 地址 */
    @ApiModelProperty(value = "地址", position = 3)
    private String address;
    /** 民族 */
    @ApiModelProperty(value = "民族", position = 3)
    private String nationName;
    /** 职称 */
    @ApiModelProperty(value = "职称", position = 3)
    private String titleName;
    /** 职务 */
    @ApiModelProperty(value = "职务", position = 12)
    private String dutyName;
    /** 学位 */
    @ApiModelProperty(value = "学位", position = 8)
    private String degreeName;
    /** 学历 */
    @ApiModelProperty(value = "学历", position = 8)
    private String educationName;
    /** 工作单位 */
    @ApiModelProperty(value = "工作单位", position = 8)
    private String jobUnit;
    /** 专业 */
    @ApiModelProperty(value = "专业", position = 8)
    private String specName;
    /** 出生年 */
    @ApiModelProperty(value = "出生年", position = 8)
    private String birthYear;
    /** 联系电话 */
    @ApiModelProperty(value = "联系电话", position = 8)
    private String phone;

    private String managerDept;
    @ApiModelProperty(value = "项目属性Id", position = 36)
    private String projAttribute;
    /** 年度总目标 */
    @ApiModelProperty(value = "年度总目标", position = 14 )
    private String yearTarget;
    /** 第一年目标 */
    @ApiModelProperty(value = "第一年目标", position = 14 )
    private String year1Goal;
    /** 第二年目标 */
    @ApiModelProperty(value = "第二年目标", position = 14 )
    private String year2Goal;
    /** 第三年目标 */
    @ApiModelProperty(value = "第三年目标", position = 14 )
    private String year3Goal;

    /** 项目组成员_总人数 */
    @ApiModelProperty(value = "项目组成员_总人数", position = 17 )
    private Integer memCount;
    /** 项目组成员_高职 */
    @ApiModelProperty(value = "项目组成员_高职", position = 18 )
    private Integer memHighCount;
    /** 项目组成员_中职 */
    @ApiModelProperty(value = "项目组成员_中职", position = 19 )
    private Integer memMiddleCount;
    /** 项目组成员_初职 */
    @ApiModelProperty(value = "项目组成员_初职", position = 20 )
    private Integer memLowCount;
    /** 项目组成员_其他 */
    @ApiModelProperty(value = "项目组成员_其他", position = 21 )
    private Integer memOtherCount;
    /** 项目组成员_博士后 */
    @ApiModelProperty(value = "项目组成员_博士研究生", position = 22 )
    private Integer memBshCount;
    /** 项目组成员_博士生 */
    @ApiModelProperty(value = "项目组成员_博士研究生", position = 22 )
    private Integer memBsCount;
    /** 项目组成员_硕士生 */
    @ApiModelProperty(value = "项目组成员_硕士研究生", position = 23 )
    private Integer memSsCount;
    /** 项目组成员_硕士生 */
    @ApiModelProperty(value = "项目组成员_学士", position = 24)
    private Integer memXsCount;
    /** 项目组成员_参加单位数 */
    @ApiModelProperty(value = "项目组成员_参加单位数", position = 25)
    private Integer workCount;

    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 4 )
    private String fileId;
    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 1 )
    private String downloadId;
    /** 附件名 */
    @ApiModelProperty(value = "附件名", position = 6)
    private String fileName;
    /** URL */
    @ApiModelProperty(value = "URL", position = 7)
    private String downloadUrl;

    /** 合作单位 */
    private List<ComProjectCooperativeUnitsDTO> cooperativeUnits;
    /** 项目主要参与单位 */
    private List<ComProjectCooperativeUnitsDTO> participateUnits;
    /** 项目组成员 */
    private List<ComProjectMembersDTO> members;
    /** 经费表 */
    private List<ComProjectBudgetDTO> budget;
    /** 年度用款计划 */
    private List<ComProjectFundPlanDTO> fundPlan;
    /** 购置设备预算明细表 */
    private List<ComProjectEquipmentDTO> deviceList;
    /** 单位支出明细预算 */
    private List<ComProjectUnitPaymentDTO> unitPayment;
    /** 项目绩效目标表 */
    private ProjectKPIStatisticDTO projectKPI;
    /** 项目安排及阶段目标 */
    private List<ComProjectStageGoalDTO> stageGoals;
    /** 项目课颖设置表 */
    private List<ComProjectSubDTO> projectSubList;
    /** 试制设备预算明细表 */
    private List<ComProjectManufactureDTO> manufactureList;
    /** 附件列表 */
    private List<ComFileDTO> fileList;
    /** 审核列表 */
    private List<ComProjectAuditNoteDTO> auditList;
}
