package com.yiboshi.science.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 参数类型表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "参数类型表VO")
public class SystemParameterType extends BaseEntity {
    /** Id */
    @ApiModelProperty(value = "Id" )
    @Length(max=36, message = "Id不能大于36")
    @TableId(value="id",type = IdType.UUID )
    private String id;
    /** 类型Id */
    @ApiModelProperty(value = "类型Id", position = 1 )
    private Integer typeId;
    /** 父Id */
    @ApiModelProperty(value = "父Id", position = 2 )
    @TableField(strategy = FieldStrategy.IGNORED)
    private Integer parentId;
    /** 名称 */
    @ApiModelProperty(value = "名称", position = 3 )
    @Length(max=200, message = "名称不能大于200")
    private String name;
    /** 标准编码 */
    @ApiModelProperty(value = "标准编码", position = 4 )
    @Length(max=50, message = "标准编码不能大于50")
    private String gbCode;
    /** 显示顺序 */
    @ApiModelProperty(value = "显示顺序", position = 5 )
    private Integer displayOrder;
    /** 系统编码 */
    @ApiModelProperty(value = "系统编码", position = 6 )
    @Length(max=200, message = "系统编码不能大于200")
    private String systemCode;
    /** 创建时间 */
    @ApiModelProperty(value="创建时间", position = 7)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date created;
    /** 最后修改时间 */
    @ApiModelProperty(value="最后修改时间", position = 8)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updated;
}