package com.yiboshi.science.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 任务书主要研发内容VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "主要研发内容VO")
public class ComProjectStageGoal extends BaseEntity {

    /** objId */
    @ApiModelProperty(value = "任务书Id", position = 1 )
    @Length(max=36, message = "任务书Id不能大于36")
    private String objectId;
    /** 内容 */
    @ApiModelProperty(value = "内容", position = 2 )
    @Length(max=3000, message = "内容不能大于3000")
    private String contentInfo;
    /** 阶段目标 */
    @ApiModelProperty(value = "阶段目标", position = 5 )
    @Length(max=3000, message = "阶段目标不能大于3000")
    private String target;
    /** 开始时间 */
    @ApiModelProperty(value = "开始时间", position = 3 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    /** 结束时间 */
    @ApiModelProperty(value = "结束时间", position = 4 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 6 )
    private Integer showIndex;

}