package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 年度用款计划表VO
 * 
 * @author xujun
 * @version 2024-11-28
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "年度用款计划表VO")
public class ComProjectFundPlan extends BaseEntity {

    /** 用款计划Id */
    @ApiModelProperty(value = "用款计划Id", position = 2 )
    @Length(max=36, message = "用款计划Id不能大于36")
    private String fundId;
    /** 对象id（项目Id/任务书Id） */
    @ApiModelProperty(value = "对象id（项目Id/任务书Id）", position = 2 )
    @Length(max=36, message = "对象id（项目Id/任务书Id）不能大于36")
    private String objectId;
    /** 年度1资金数额 */
    @ApiModelProperty(value = "年度1资金数额", position = 3 )
    private BigDecimal yearValue1;
    /** 年度2资金数额 */
    @ApiModelProperty(value = "年度2资金数额", position = 3 )
    private BigDecimal yearValue2;
    /** 年度3资金数额 */
    @ApiModelProperty(value = "年度3资金数额", position = 3 )
    private BigDecimal yearValue3;
    /** 年度4资金数额 */
    @ApiModelProperty(value = "年度4资金数额", position = 3 )
    private BigDecimal yearValue4;
    /** 年度5资金数额 */
    @ApiModelProperty(value = "年度5资金数额", position = 3 )
    private BigDecimal yearValue5;
    /** 总金额 */
    @ApiModelProperty(value = "总金额", position = 3)
    private BigDecimal totalAmount;
}