package com.yiboshi.science.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目表VO
 *
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "项目表VO")
public class ComProject extends BaseEntity {
    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    @Length(max=150, message = "项目名称不能大于50")
    private String projName;
    /** 项目名称(英文) */
    @ApiModelProperty(value = "项目名称(英文)", position = 1 )
    @Length(max=500, message = "项目名称(英文)不能大于500")
    private String englishName;
    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 2 )
    @Length(max=100, message = "项目编号不能大于100")
    private String projNo;
    /** 申请编号 */
    @ApiModelProperty(value = "申请编号", position = 4 )
    @Length(max=200, message = "申请编号不能大于200")
    private String appNo;
    /** 版本号 */
    @ApiModelProperty(value = "版本号", position = 5 )
    @Length(max=20, message = "版本号不能大于20")
    private String versionNo;
    /** 申报单位Id */
    @ApiModelProperty(value = "申报单位Id", position = 8 )
    @Length(max=36, message = "申报单位Id不能大于36")
    private String appUnitId;
    /** 申报人Id */
    @ApiModelProperty(value = "申报人Id", position = 9 )
    @Length(max=36, message = "申报人Id不能大于36")
    private String appPersonId;
    /** 申报年度 */
    @ApiModelProperty(value = "申报年度", position = 6 )
    private Integer reportYear;
    /** 申报批次 */
    @ApiModelProperty(value = "申报批次", position = 7 )
    private Integer batch;
    /** 主管处室 */
    @ApiModelProperty(value = "主管处室", position = 1)
    private String managerDept;
    /** 项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项 */
    @ApiModelProperty(value = "项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项", position = 7 )
    private Integer projState;
    /** 项目类型  1 科研项目  2重点学科项目 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    private Integer systemType;
    /** 项目类别 (1 一般项目 2重点项目)*/
    @ApiModelProperty(value = "项目类别 (1 一般项目 2重点项目)", position = 3 )
    private Integer projClass;
    /** 项目开始时间 */
    @ApiModelProperty(value = "项目开始时间", position = 10 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /** 项目结束时间 */
    @ApiModelProperty(value = "项目结束时间", position = 11 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
    /** 学科Id */
    @ApiModelProperty(value = "学科Id", position = 16 )
    @Length(max=36, message = "学科Id不能大于36")
    private String knowledgeId;
    /** 专家/专家组是否评审完成  0否 1是 */
    @ApiModelProperty(value = "是否评审完成", position = 6 )
    private Integer completed;
    /** 分配状态 0未分配 1已分配 */
    @ApiModelProperty(value = "分配状态", position = 6 )
    private Integer assignState;
    /** 总分 */
    @ApiModelProperty(value = "总分", position = 4)
    private BigDecimal totalScore;
    /** 平均分 */
    @ApiModelProperty(value = "平均分", position = 4)
    private BigDecimal averageScore;
    /** 技术专家总分 */
    @ApiModelProperty(value = "技术专家总分", position = 4)
    private BigDecimal technologyScore;
    /** 技术专家平均分 */
    @ApiModelProperty(value = "技术专家平均分", position = 4)
    private BigDecimal technologyAverageScore;
    /** 财务专家总分 */
    @ApiModelProperty(value = "财务专家总分", position = 4)
    private BigDecimal economyScore;
    /** 财务专家平均分 */
    @ApiModelProperty(value = "财务专家平均分", position = 4)
    private BigDecimal economyAverageScore;
    /** 计算得分 */
    @ApiModelProperty(value = "计算得分", position = 4)
    private BigDecimal calculateScore;
    /** 答辩技术专家评分 */
    @ApiModelProperty(value = "答辩技术专家评分", position = 4)
    private BigDecimal defenseTechnologyScore;
    /** 答辩账务专家评分 */
    @ApiModelProperty(value = "答辩账务专家评分", position = 4)
    private BigDecimal defenseEconomyScore;
    /** 答辩总得分 */
    @ApiModelProperty(value = "答辩总得分", position = 4)
    private BigDecimal defenseScore;
    /** 项目完成状态 */
    @ApiModelProperty(value = "项目完成状态", position = 38 )
    private String completeStatus;
    /** 是否终审返回修改  0否 1是 */
    @ApiModelProperty(value = "是否终审返回修改", position = 6 )
    private Integer isFinalReturned;
}
