package com.yiboshi.science.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 申报人员简历表
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "申报人员简历表VO")
public class ComPersonResume extends BaseEntity {

    /** 人才申请Id */
    @ApiModelProperty(value = "人才申请Id", position = 2)
    @Length(max=36, message = "人才申请Id不能大于36")
    private String talentId;
    /** 简历类型(系统参数18) */
    @ApiModelProperty(value = "简历类型", position = 3)
    @Length(max=36, message = "简历类型不能大于36")
    private String resumeType;
    /** 起始日期 */
    @ApiModelProperty(value = "起始日期", position = 4)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date resumeStart;
    /** 截止日期 */
    @ApiModelProperty(value = "截止日期", position = 5)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date resumeEnd;
    /** 机构名称 */
    @ApiModelProperty(value = "机构名称", position = 6)
    @Length(max=200, message = "机构名称不能大于200")
    private String orgName;
    /** 职务 */
    @ApiModelProperty(value = "职务", position = 7)
    @Length(max=20, message = "职务不能大于20")
    private String positionName;
    /** 简历备注 */
    @ApiModelProperty(value = "简历备注", position = 8)
    @Length(max=100, message = "简历备注不能大于100")
    private String resumeRemark;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 9)
    private Integer showIndex;
} 