package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 *  通知公告表
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Getter
@Setter
public class ComNotice extends BaseEntity {
    /** 标题 */
    @ApiModelProperty(value = "标题", position = 1)
    @Length(max=36, message = "标题不能大于200")
    private String title;
    /** 内容 */
    @ApiModelProperty(value = "内容", position = 2)
    private String content;
}