package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "专家评审专业表")
public class ComExpertSpec extends BaseEntity {
    /** 专家Id */
    @ApiModelProperty(value = "专家Id", position = 1)
    @Length(max=36, message = "专家Id不能大于36")
    private String expertId;
    /** 专业Id */
    @ApiModelProperty(value = "专业Id", position = 2)
    @Length(max=36, message = "专业Id不能大于36")
    private String specId;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 5)
    private Integer showIndex;
}
