package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.ComProjectMembers;
import com.yiboshi.science.param.dto.ComProjectMembersDTO;
import com.yiboshi.science.param.query.ComProjectMembersQueryVO;

import java.util.List;

/**
 * 项目组成员表 DAO
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectMembersDAO extends BaseMapper<ComProjectMembers>, BaseDAO<ComProjectMembersQueryVO,ComProjectMembersDTO, ComProjectMembers> {
    List<ComProjectMembersDTO> getListByObjectId(String objectId);
    ComProjectMembersDTO getMemCountById(String objectId);
    Integer getMemWorkCountByObjectId(String objectId);
}
