/* Copyright (c) 2018, yiboshi.com All Rights Reserved. */
package com.yiboshi.science.base;

import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * Service基类
 *
 * @author NEGI
 * @version 2018-11
 */
@SuppressWarnings("unused")
public interface BaseService<QueryVO extends PaginationVO, DTO extends BaseDTO, Entity> extends IService<Entity> {
    /**
     * 新增数据
     *
     * @param e 数据vo
     * @return 生成的id
     */
    String insert(Entity e);

    /**
     * 批量插入(不支持外部事务)
     *
     * @param dataList 数据集合
     */
    void insertBatch(List<Entity> dataList);

    /**
     * 批量保存（新增或更新）
     *
     * @param dataList 数据集合
     */
    void insertOrUpdateBatch(List<Entity> dataList);

    /**
     * 更新全部数据
     *
     * @param e 数据vo
     * @return 更新的id
     */
    String update(Entity e);

    /**
     * 更新部分数据
     *
     * @param e 数据vo
     * @return 更新的id
     */
    String updateSelective(Entity e);

    /**
     * 根据主键删除
     *
     * @param id 主键
     */
    void deleteById(String id);

    /**
     * 根据主键删除
     *
     * @param idList 主键
     */
    void deleteByIds(List<String> idList);

    /**
     * 根据条件删除
     *
     * @param e 主键
     */
    boolean delete(Entity e);

    /**
     * 批量更新(不支持外部事务)
     *
     * @param dataList 数据集合
     */
    void updateBatch(List<Entity> dataList);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return dto实体
     */
    Entity entityById(String id);

    /**
     * 根据实体查询
     *
     * @param e 实体
     * @return Entity实体
     */
    Entity getEntity(Entity e);

    /**
     * 条件查询结果集
     *
     * @param e 查询条件
     * @return 数据集合
     */
    List<Entity> entityList(Entity e);

    /**
     * 条件查询结果集
     *
     * @return 数据集合
     */
    List<Entity> entityAll();


    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return dto实体
     */
    DTO dtoById(String id);

    /**
     * 根据实体查询
     *
     * @param e 实体
     * @return Entity实体
     */
    DTO getDto(Entity e);

    /**
     * 根据实体查询
     *
     * @param e 实体
     * @return Entity实体
     */
    List<DTO> dtoList(Entity e);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return dto实体
     */
    QueryVO queryById(String id);

    /**
     * 根据实体查询
     *
     * @param e 实体
     * @return Entity实体
     */
    QueryVO getQuery(Entity e);

    /**
     * 根据实体查询
     *
     * @param vo 实体
     * @return Entity实体
     */
    List<QueryVO> queryList(Entity vo);

    /**
     * 条件所有结果集
     *
     * @return 数据集合
     */
    List<QueryVO> queryAll();

    /**
     * 条件查询记录数
     *
     * @param vo 查询条件
     * @return 记录数
     */
    long count(QueryVO vo);

    /**
     * 多表分页查询
     *
     * @param vo 查询条件
     * @return 分页对象
     */
    Pagination<DTO> getListByPage(QueryVO vo);
}