package com.yiboshi.science.utils;


import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.properties.HorizontalAlignment;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.VerticalAlignment;
import com.itextpdf.text.DocumentException;

import java.text.SimpleDateFormat;
import java.util.Objects;

import static com.yiboshi.science.utils.ProjectInfoToPDF.getCurrentOperatingSystem;

/**
 * PDF工具
 *
 * @author ppp
 * @date 2022/8/5
 */
public class PdfUtil {

    static float borderWidth = 1f;
    static Border unitedBorder = new SolidBorder(new DeviceRgb(0, 0, 0), borderWidth);

    private static PdfFont createFont(String fontName) {
        try {
            if ("linux".equals(getCurrentOperatingSystem())) {
                if (fontName.toLowerCase().endsWith(".ttc"))
                    return PdfFontFactory.createFont("/usr/share/fonts/" + fontName + ",0", PdfEncodings.IDENTITY_H);
                else
                    return PdfFontFactory.createFont("/usr/share/fonts/" + fontName, PdfEncodings.IDENTITY_H);
            } else {
                if (fontName.toLowerCase().endsWith(".ttc"))
                    return PdfFontFactory.createFont("c:/Windows/Fonts/" + fontName + ",0", PdfEncodings.IDENTITY_H);
                else
                    return PdfFontFactory.createFont("c:/Windows/Fonts/" + fontName, PdfEncodings.IDENTITY_H);
            }
        } catch (Exception e) {
            throw new RuntimeException("加载字体文件失败，请确保系统中存在字体文件 " + fontName + "：" + e.getMessage(), e);
        }
    }
    public static void addTablePageCell(Table table, String label, String value, Integer labelColspan, Integer valueColspan, PdfFont font) {
        if (Objects.isNull(labelColspan))
            labelColspan = 1;
        if (Objects.isNull(valueColspan))
            valueColspan = 1;
        Cell labelCell = new Cell(1, labelColspan);
        labelCell.setMinHeight(36f);
        labelCell.setVerticalAlignment(VerticalAlignment.BOTTOM);
        labelCell.setHorizontalAlignment(HorizontalAlignment.LEFT);
        labelCell.setBorder(new SolidBorder(new DeviceRgb(0, 0, 0), 0.1f)); // 设置边框宽度
        labelCell.add(new Paragraph(label != null ? label.toString() : "").setFont(font).setFontSize(15));
        labelCell.setBorder(Border.NO_BORDER);
        table.addCell(labelCell);

        Cell valueCell = new Cell(1, valueColspan);
        valueCell.setPadding(3f);
        valueCell.setMinHeight(36f);
        valueCell.setVerticalAlignment(VerticalAlignment.BOTTOM);
        valueCell.setHorizontalAlignment(HorizontalAlignment.LEFT);
        // 只设置下边框
        valueCell.setBorderTop(Border.NO_BORDER);
        valueCell.setBorderLeft(Border.NO_BORDER);
        valueCell.setBorderRight(Border.NO_BORDER);
        valueCell.setBorderBottom(unitedBorder);
        valueCell.add(new Paragraph(value != null ? value.toString() : "").setFont(font).setFontSize(15));
        table.addCell(valueCell);
    }

    public static void addValueCell(Table table, String label, Integer labelColspan, String value, Integer valueColspan, Float height, PdfFont font, Float fontSize, VerticalAlignment vertical, HorizontalAlignment horizontal) {
        addCell(table, label, labelColspan, null, height, font, fontSize, vertical, horizontal);
        addCell(table, value, valueColspan, null, height, font, fontSize, vertical, horizontal);
    }

    public static void addCell(Table table, Object value, Integer colspan, Integer rowspan, Float height, PdfFont font, Float fontSize, VerticalAlignment vertical, HorizontalAlignment horizontal) {
        if (Objects.isNull(font))
            font = createFont("simsun.ttc");
        if (Objects.isNull(fontSize))
            fontSize = 10.5f;
        if (Objects.isNull(height))
            height = 25.5f;
        if (Objects.isNull(colspan))
            colspan = 1;
        if (Objects.isNull(rowspan))
            rowspan = 1;
        if (Objects.isNull(vertical))
            vertical = VerticalAlignment.MIDDLE;
        if (Objects.isNull(horizontal))
            horizontal = HorizontalAlignment.CENTER;
        Cell cell = new Cell(rowspan, colspan);
        cell.setPadding(5f);
        cell.setMinHeight(height);
        cell.setVerticalAlignment(vertical);
        cell.setHorizontalAlignment(horizontal);

        cell.setBorderRight(unitedBorder);
        cell.setBorderBottom(unitedBorder);
        // 创建段落并检查字体
        cell.add(new Paragraph(value != null ? value.toString() : "").setFont(font).setFontSize(fontSize));
        table.addCell(cell);
    }
    public static void setParagraph(Document document, Object value, PdfFont font, float FontSize, boolean bold) throws DocumentException {
        Paragraph paragraph = new Paragraph(value != null ? value.toString() : "")
                .setFont(font)
                .setFontSize(FontSize)
                .setTextAlignment(TextAlignment.LEFT)     // 设置文字对齐方式
                .setMarginLeft(1f);      // 设置左缩进
        if (bold) {
            paragraph.setBold();
        }
        document.add(paragraph);
    }
}
