package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectMembersDAO;
import com.yiboshi.science.entity.ComProjectMembers;
import com.yiboshi.science.param.dto.ComProjectMembersDTO;
import com.yiboshi.science.param.query.ComProjectMembersQueryVO;
import com.yiboshi.science.service.ComProjectMembersService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 项目组成员表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComProjectMembersServiceImpl extends BaseServiceImpl<ComProjectMembersDAO, ComProjectMembersQueryVO, ComProjectMembersDTO, ComProjectMembers> implements ComProjectMembersService {

    @Autowired
    private ComProjectMembersDAO comProjectMembersDAO;

    @Override
    protected void setCriteriaForQuery(ComProjectMembersQueryVO vo, QueryWrapper<ComProjectMembersQueryVO> criteria) {
        if (Objects.nonNull(vo.getObjectId())) {
            criteria.eq("object_id", vo.getObjectId());
        }
        if (Objects.nonNull(vo.getName())) {
            criteria.eq("name", vo.getName());
        }
        if (Objects.nonNull(vo.getBirthday())) {
            criteria.eq("birthday", vo.getBirthday());
        }
        if (Objects.nonNull(vo.getDegree())) {
            criteria.eq("degree", vo.getDegree());
        }
        if (Objects.nonNull(vo.getTitle())) {
            criteria.eq("title", vo.getTitle());
        }
        if (Objects.nonNull(vo.getResearchDirection())) {
            criteria.eq("research_direction", vo.getResearchDirection());
        }
        if (Objects.nonNull(vo.getWorkUnit())) {
            criteria.eq("work_unit", vo.getWorkUnit());
        }
        if (Objects.nonNull(vo.getProjWork())) {
            criteria.eq("proj_work", vo.getProjWork());
        }
        if (Objects.nonNull(vo.getForMonths())) {
            criteria.eq("for_months", vo.getForMonths());
        }
        if (Objects.nonNull(vo.getShowIndex())) {
            criteria.eq("show_index", vo.getShowIndex());
        }
        if (Objects.nonNull(vo.getRole())) {
            criteria.eq("role", vo.getRole());
        }
    }

    @Override
    public List<ComProjectMembersDTO> getListByObjectId(String objectId) {
        List<ComProjectMembersDTO> list = comProjectMembersDAO.getListByObjectId(objectId);
        return list;
    }

    @Override
    public void insertList(List<ComProjectMembersDTO> list, String objectId) {
        ComProjectMembers model = new ComProjectMembers();
        model.setObjectId(objectId);
        this.delete(model);
//        if (!isObjectNull(membersList.get(i)))
        if (null != list) {
            List<ComProjectMembers> iList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                    ComProjectMembers item = convert2Entity(list.get(i));
                    item.setFileId(list.get(i).getDownloadId());
                    if (i == 0)
                        item.setRole(1);
                    else
                        item.setRole(2);
                    item.setShowIndex(i + 1);
                    item.setObjectId(objectId);
                    iList.add(item);
            }
            this.insertBatch(iList);
        }
    }

    @Override
    public void deleteByObjectId(String objectId) {
        ComProjectMembers e = new ComProjectMembers();
        e.setObjectId(objectId);
        this.delete(e);
    }


    @Override
    public ComProjectMembersDTO getMemCountById(String objectId) {
        ComProjectMembersDTO member = comProjectMembersDAO.getMemCountById(objectId);
        member.setWorkCount(comProjectMembersDAO.getMemWorkCountByObjectId(objectId));
        return member;
    }
}
