package com.yiboshi.science.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectCooperativeUnitsDAO;
import com.yiboshi.science.entity.ComProjectCooperativeUnits;
import com.yiboshi.science.param.dto.ComProjectCooperativeUnitsDTO;
import com.yiboshi.science.param.query.ComProjectCooperativeUnitsQueryVO;
import com.yiboshi.science.service.ComProjectCooperativeUnitsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 合作单位表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComProjectCooperativeUnitsServiceImpl extends BaseServiceImpl<ComProjectCooperativeUnitsDAO, ComProjectCooperativeUnitsQueryVO, ComProjectCooperativeUnitsDTO, ComProjectCooperativeUnits> implements ComProjectCooperativeUnitsService {

    @Autowired
    private ComProjectCooperativeUnitsDAO comProjectCooperativeUnitsDAO;

    @Override
    protected void setCriteriaForQuery(ComProjectCooperativeUnitsQueryVO vo, QueryWrapper<ComProjectCooperativeUnitsQueryVO> criteria) {
        if (Objects.nonNull(vo.getObjectId())) {
            criteria.eq("object_id", vo.getObjectId());
        }
        if (Objects.nonNull(vo.getUnitName())) {
            criteria.eq("unit_name", vo.getUnitName());
        }
        if (Objects.nonNull(vo.getUnitAddress())) {
            criteria.eq("unit_address", vo.getUnitAddress());
        }
        if (Objects.nonNull(vo.getProjectWork())) {
            criteria.eq("project_work", vo.getProjectWork());
        }
    }

    public List<ComProjectCooperativeUnitsDTO> getListByObjectId(String objectId, int type) {
        return comProjectCooperativeUnitsDAO.getListByObjectId(objectId,type);
    }

    public void insertList(List<ComProjectCooperativeUnitsDTO> list, String objectId, int type) {
        ComProjectCooperativeUnits model = new ComProjectCooperativeUnits();
        model.setObjectId(objectId);
        model.setType(type);
        this.delete(model);
        if (null != list) {
            List<ComProjectCooperativeUnits> iList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                ComProjectCooperativeUnits item = convert2Entity(list.get(i));
                item.setObjectId(objectId);
                item.setType(type);
                item.setShowIndex(i + 1);
                iList.add(item);
            }
            this.insertBatch(iList);
        }
    }

    public void deleteByObjectId(String objectId, int type) {
        ComProjectCooperativeUnits model = new ComProjectCooperativeUnits();
        model.setObjectId(objectId);
        model.setType(type);
        this.delete(model);
    }


}
