package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectBasicDAO;
import com.yiboshi.science.entity.ComProjectBasic;
import com.yiboshi.science.param.dto.ComProjectBasicDTO;
import com.yiboshi.science.param.dto.ComProjectDTO;
import com.yiboshi.science.param.query.ComProjectBasicQueryVO;
import com.yiboshi.science.service.ComProjectBasicService;
import com.yiboshi.science.utils.StringUtil;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@AllArgsConstructor
public class ComProjectBasicServiceImpl extends BaseServiceImpl<ComProjectBasicDAO, ComProjectBasicQueryVO, ComProjectBasicDTO, ComProjectBasic> implements ComProjectBasicService {

    @Autowired
    private ComProjectBasicDAO comProjectBasicDAO;

    @Override
    protected void setCriteriaForQuery(ComProjectBasicQueryVO vo, QueryWrapper<ComProjectBasicQueryVO> criteria) {

    }

    @Transactional
    public String insertOrUpdate(ComProjectDTO dto) {
        ComProjectBasic model = new ComProjectBasic();
        model.setProjId(dto.getId());
        model = this.getEntity(model);
        String id = "";
        if (null == model) {
            model = new ComProjectBasic();
            StringUtil.copyObj2Obj(dto, model);
            model.setProjId(dto.getId());
            id = this.insert(model);
        } else {
            id = model.getId();
            model = new ComProjectBasic();
            StringUtil.copyObj2Obj(dto, model);
            model.setId(id);
            model.setProjId(dto.getId());
            this.update(model);
        }
        return id;
    }

    public void deleteByProjId(String projId){
        ComProjectBasic model = new ComProjectBasic();
        model.setProjId(projId);
        this.delete(model);
    }
}
