package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComPersonResumeDAO;
import com.yiboshi.science.entity.ComPersonResume;
import com.yiboshi.science.param.dto.ComPersonResumeDTO;
import com.yiboshi.science.param.query.ComPersonResumeQueryVO;
import com.yiboshi.science.service.ComPersonResumeService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 申报人学习、研修与工作简历表 Service 实现类
 * @author xujun
 * @version 2025-03-12
 */

@Service
@AllArgsConstructor
public class ComPersonResumeServiceImpl extends BaseServiceImpl<ComPersonResumeDAO, ComPersonResumeQueryVO, ComPersonResumeDTO, ComPersonResume> implements ComPersonResumeService {

    @Autowired
    private ComPersonResumeDAO comPersonResumeDAO;

    @Override
    protected void setCriteriaForQuery(ComPersonResumeQueryVO vo, QueryWrapper<ComPersonResumeQueryVO> criteria) {

    }

    public void insertList(List<ComPersonResumeDTO> list, String TalentId, String TypeId) {
        ComPersonResume resume = new ComPersonResume();
        resume.setTalentId(TalentId);
        resume.setResumeType(TypeId);
        this.delete(resume);

        if (null != list) {
            List<ComPersonResume> iList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                ComPersonResume item = convert2Entity(list.get(i));
                item.setTalentId(TalentId);
                item.setResumeType(TypeId);
                iList.add(item);
            }
            this.insertBatch(iList);
        }
    }

    public List<ComPersonResumeDTO> getListByTalentId(String TalentId) {
        return comPersonResumeDAO.getListByTalentId(TalentId);
    }

    public void deleteByObjectId(String objectId) {
        ComPersonResume e = new ComPersonResume();
        e.setTalentId(objectId);
        this.delete(e);
    }
}
