package com.yiboshi.science.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComFileDAO;
import com.yiboshi.science.entity.ComFile;
import com.yiboshi.science.param.dto.ComFileDTO;
import com.yiboshi.science.param.query.ComFileQueryVO;
import com.yiboshi.science.service.ComFileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 附件目录表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComFileServiceImpl extends BaseServiceImpl<ComFileDAO, ComFileQueryVO, ComFileDTO, ComFile> implements ComFileService {
    @Autowired
    private ComFileDAO ComFileDAO;

    protected void setCriteriaForQuery(ComFileQueryVO vo, QueryWrapper<ComFileQueryVO> criteria) {
        if (Objects.nonNull(vo.getDownloadId())) {
            criteria.eq("download_id", vo.getDownloadId());
        }
        if (Objects.nonNull(vo.getObjectId())) {
            criteria.eq("object_id", vo.getObjectId());
        }
        if (Objects.nonNull(vo.getFileExplain())) {
            criteria.eq("file_explain", vo.getFileExplain());
        }
    }

    @Override
    public List<ComFileDTO> getListByObjectId(String objectId, int fileType) {
        return ComFileDAO.getListByObjectId(objectId, fileType);
    }

    @Override
    public void insertList(List<ComFileDTO> list, String objectId, int type) {
        ComFile file = new ComFile();
        file.setFileType(type);
        file.setObjectId(objectId);
        this.delete(file);
        if (null != list) {
            for (int i = 0; i < list.size(); i++) {
                if (!isObjectNull(list.get(i))) {
                    list.get(i).setFileType(type);
                    list.get(i).setObjectId(objectId);
                    list.get(i).setShowIndex(i + 1);
                    ComFile comFile = convert2Entity(list.get(i));
                    this.insert(comFile);
                }
            }
        }
    }

    @Override
    public void deleteByObjectId(String objectId) {
        ComFile E = new ComFile();
        E.setObjectId(objectId);
        this.delete(E);
    }
}
