package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.SystemUserRole;
import com.yiboshi.science.param.dto.SystemUserDTO;
import com.yiboshi.science.param.dto.SystemUserRoleDTO;
import com.yiboshi.science.param.query.SystemUserRoleQueryVO;

import java.util.List;

/**
 * 用户角色表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface SystemUserRoleService extends BaseService<SystemUserRoleQueryVO, SystemUserRoleDTO, SystemUserRole> {

    /**
     * 根据用户Id获取角色
     *
     * @param userId
     * @return
     */
    String getRolesByUserId(String userId);

    /**
     * 根据用户Id获取角色
     *
     * @param userId
     * @return
     */
   List<String> getRolesListByUserId(String userId);
    /**
     * 根据 id 更改状态
     *
     * @param id
     * @return
     */
    String updateStateById(String id, Integer state);
    /**
     * 根据 用户id 增加角色
     *
     * @param userId
     * @return
     */
    void addRoleByUserId(String userId, String roleId);
    /**
     * 根据 用户id 删除角色
     *
     * @param userId
     * @return
     */
    void deleteRoleByUserId(String userId, String role);
    /**
     * 根据 人员id 增加角色
     *
     * @param personId
     * @return
     */
    void addRoleByPersonId(String personId, String role);
    /**
     * 根据 用户id 更改角色
     *
     * @param id
     * @return
     */
    void updateRoleByUserId(String userId, String id, String roleId);
    /**
     * 根据 人员证件号 获取角色
     *
     * @param certId
     * @return
     */
    SystemUserDTO getUserRoleByCertId(String certId, String roleId);

}
