package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComTaskTarget;
import com.yiboshi.science.param.dto.ComTaskTargetDTO;
import com.yiboshi.science.param.query.ComTaskTargetQueryVO;

import java.util.List;

/**
 * 任务书预期成果表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComTaskTargetService extends BaseService<ComTaskTargetQueryVO, ComTaskTargetDTO,ComTaskTarget> {

    /** 根据对象获取预期成果列表
     *
     * @param objectId
     * @return
     */
    List<ComTaskTargetDTO> getListByObjectId(String objectId);

    /** 插入预期成果列表
     *
     * @param testTargetList
     * @param objectId
     */
    void insertTestTargetList(List<ComTaskTargetDTO> testTargetList, String objectId);

    /**h获取空列表
     *
     * @return
     */
    List<ComTaskTargetDTO> getList();
}
