package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.AssignCount;
import com.yiboshi.science.entity.ComTalentAssign;
import com.yiboshi.science.param.dto.ComTalentAssignDTO;
import com.yiboshi.science.param.dto.ComTalentGroupDTO;
import com.yiboshi.science.param.query.ComTalentAssignQueryVO;

import java.util.List;
import java.util.Map;

/**
 * 人才专家分配明细表
 */
public interface ComTalentAssignService extends BaseService<ComTalentAssignQueryVO, ComTalentAssignDTO, ComTalentAssign> {

    /**
     * 分配项目
     *
     * @return
     */

    String assignTalent(Map<String, Object> map);
    /**
     * 根据Id获取分配专家信息
     *
     * @return
     */
    ComTalentAssignDTO getAssignExpertById(String id);
    /**
     * 获取分配专家列表
     *
     * @return
     */
    List<ComTalentAssignDTO> getAssignExpertList(String talentId);
    /**
     * 删除分配专家
     *
     * @return
     */
    String deleteAssignExpert(String id);

    /**
     * 专家评分
     *
     * @return
     */
    String expertEvaluation(ComTalentAssignDTO dto);
    /**
     * 获取分配专家人数
     *
     * @return
     */
    List<AssignCount> getAssignCount(String expertId);
    /**
     * 分配专家
     *
     * @return
     */
    String assignTalent(Integer year, List<String> talents, List<String> experts);
    /**
     * 更新分配状态
     *
     * @return
     */
    void updateAssignState(String talentId);
    /**
     * 更新分配状态
     *
     * @return
     */
    List<ComTalentGroupDTO> getTalentGroupAssignById(String id, String expertId);
}
