package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectStageGoal;
import com.yiboshi.science.param.dto.ComProjectStageGoalDTO;
import com.yiboshi.science.param.query.ComProjectStageGoalQueryVO;

import java.util.List;

/**
 * 任务书主要研发内容 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectStageGoalService extends BaseService<ComProjectStageGoalQueryVO, ComProjectStageGoalDTO,ComProjectStageGoal> {

    /** 根据对象获取主要研发内容
     *
     * @param objectId
     * @return
     */
    List<ComProjectStageGoalDTO> getListByObjectId(String objectId);
    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId);
    /**插入内容列表
     *
     * @param list
     * @param objectId
     */
    void  insertList(List<ComProjectStageGoalDTO> list, String objectId);
}
