package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectManagementRule;
import com.yiboshi.science.param.dto.ComProjectManagementRuleDTO;
import com.yiboshi.science.param.query.ComProjectManagementRuleQueryVO;

import java.util.List;

/**
 * 单位科研项目及资金管理制度表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectManagementRuleService extends BaseService<ComProjectManagementRuleQueryVO, ComProjectManagementRuleDTO, ComProjectManagementRule> {
    /** 获取列表
     *
     * @param objectId
     * @return
     */
    List<ComProjectManagementRuleDTO> getListByObjectId(String objectId);

    /** 插入列表
     *
     * @param fileList
     * @param objectId
     */
    void insertList(List<ComProjectManagementRuleDTO> fileList, String objectId);
    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId);
}
