package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComFile;
import com.yiboshi.science.param.dto.ComFileDTO;
import com.yiboshi.science.param.query.ComFileQueryVO;

import java.util.List;

/**
 * 附件目录表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComFileService extends BaseService<ComFileQueryVO, ComFileDTO,ComFile> {
    /** 获取文件列表
     *
     * @param objectId
     * @return
     */
    List<ComFileDTO> getListByObjectId(String objectId, int type);

    /** 插入文件列表
     *
     * @param fileList
     * @param objectId
     */
    void insertList(List<ComFileDTO> fileList, String objectId, int type);
    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId);
}
