package com.yiboshi.science.rest.v1;


import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.config.annotation.Logs;
import com.yiboshi.science.entity.ComPerson;
import com.yiboshi.science.entity.SystemUserRole;
import com.yiboshi.science.enumeration.CommonEnum;
import com.yiboshi.science.param.dto.SystemUserRoleDTO;
import com.yiboshi.science.param.query.SystemUserRoleQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.SystemUserRoleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 功能：用户角色表 接口
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "system-user-role",description = "用户角色表")
@RestController
@RequestMapping("/v1/science-admin/system-user-role")
public class SystemUserRoleController extends BaseController<SystemUserRoleService, SystemUserRoleQueryVO, SystemUserRoleDTO, SystemUserRole> {

    @Autowired
    private SystemUserRoleService systemUserRoleService;

    /**
     * 功能:修改角色状态
     *
     * @param e 输入值
     */
    @ApiOperation(value = "1.02", httpMethod = "POST", notes = "1.02 修改人员状态")
    @RequestMapping("/updateRoleState")
    @PostMapping
    @Logs(value = CommonEnum.logType.personStateUpdate)
    public ResponseDataModel<String> updatePersonState(@RequestBody ComPerson e) {
        return ResponseDataModel.ok(systemUserRoleService.updateStateById(e.getId(), e.getPersonState()));
    }
}
