package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.LogsOperation;
import com.yiboshi.science.entity.SelectListItem;
import com.yiboshi.science.enumeration.CommonEnum;
import com.yiboshi.science.param.dto.LogsOperationDTO;
import com.yiboshi.science.param.query.LogsOperationQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.LogsOperationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * 功能：操作日志表 接口
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "logs-operation",description = "操作日志表")
@RestController
@RequestMapping("/v1/science-admin/logs-operation")
public class LogsOperationController extends BaseController<LogsOperationService, LogsOperationQueryVO, LogsOperationDTO, LogsOperation> {

    @Autowired
    private LogsOperationService logsOperationService;

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getListByPage")
    public ResponseDataModel<Pagination<LogsOperationDTO>> getListByPage(@Validated LogsOperationQueryVO vo, BindingResult bindingResult) {
        Pagination<LogsOperationDTO> page = logsOperationService.getListByPage(vo);
        return ResponseDataModel.ok(page);
    }

    @ApiOperation(value = "获取操作日志类型列表", httpMethod = "GET", notes = "获取操作日志类型列表")
    @GetMapping
    @RequestMapping("/getOperationLogType")
    public ResponseDataModel<List<SelectListItem>> getOperationLogType() {
        List<SelectListItem> list = new ArrayList<>();
        SelectListItem item = new SelectListItem();
        item.setKey("");
        item.setTitle("--全部--");
        list.add(item);
        for (CommonEnum.logType type : CommonEnum.logType.values()) {
            item = new SelectListItem();
            item.setKey(type.getKey());
            item.setTitle(type.getDescription());
            list.add(item);
        }
        return ResponseDataModel.ok(list);
    }
}
