package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 查询异常日志VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询异常日志VO")
public class LogsExceptionQueryVO extends PaginationVO{
    /** 日志级别 1紧急 2一般 */
    @ApiModelProperty(value = "日志级别 1紧急 2一般", position = 1)
    private Integer logLevel;
    /** 标题 */
    @ApiModelProperty(value = "标题", position = 2)
    private String shortTitle;
    /** ip */
    @ApiModelProperty(value = "ip", position = 3)
    private String ipAddress;
    /** 操作人Id */
    @ApiModelProperty(value = "操作人Id", position = 4)
    private String customerId;
    /** 操作页面 */
    @ApiModelProperty(value = "操作页面", position = 5)
    private String pageUrl;
    /** 请求地址 */
    @ApiModelProperty(value = "请求地址", position = 6)
    private String requestUrl;
    /** 日志参数 */
    @ApiModelProperty(value = "日志参数", position = 3)
    private String logParam;
    /** 日志内容 */
    @ApiModelProperty(value = "日志内容", position = 7)
    private String message;

    /** 起始时间 */
    @ApiModelProperty(value = "起始时间", position = 10)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /** 截止时间 */
    @ApiModelProperty(value = "截止时间", position = 11)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
}