package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "专家批次表VO")
public class ComExpertBatchQueryVO extends PaginationVO {
    /** 名称 */
    @ApiModelProperty(value = "专家Id", position = 1)
    @Length(max=200, message = "备注不能大于200")
    private String name;
    /** 年度 */
    @ApiModelProperty(value = "专家Id", position = 1)
    private Integer year;
    /** 批次 */
    @ApiModelProperty(value = "申报批次", position = 7 )
    private Integer batch;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 1)
    @Length(max=200, message = "备注不能大于200")
    private String remark;
}
