package com.yiboshi.science.param.query;

import com.yiboshi.science.base.BaseDTO;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 *  结题主要研究人员表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "结题主要研究人员表VO")
public class ComConclusionResearchersQueryVO extends PaginationVO {
    /** 结题信息表id */
    @ApiModelProperty(value = "结题信息表id", position = 1)
    @Length(max=36, message = "结题信息表id不能大于36")
    private String conclusionId;
    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 3)
    @Length(max=36, message = "姓名不能大于50")
    private String name;
    /** 性别 */
    @ApiModelProperty(value = "性别", position = 3)
    @Length(max=36, message = "性别不能大于2")
    private String sex;
    /** 年龄 */
    @ApiModelProperty(value = "金额", position = 4)
    private Integer age;
    /** 技术职称 */
    @ApiModelProperty(value = "技术职称", position = 5)
    @Length(max=36, message = "技术职称不能大于36")
    private String technicalTitle;
    /** 主要贡献 */
    @ApiModelProperty(value = "主要贡献", position = 6)
    @Length(max=36, message = "主要贡献不能大于1000")
    private String contributions;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 10 )
    private Integer showIndex;
}