package com.yiboshi.science.param.dto;

import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 参数类型表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "参数类型表DTO")
public class SystemParameterTypeDTO extends BaseDTO {
    /** 类型Id */
    @ApiModelProperty(value = "类型Id", position = 1)
    private Integer typeId;
    /** 父Id */
    @ApiModelProperty(value = "父Id", position = 2)
    private Integer parentId;
    /** 名称 */
    @ApiModelProperty(value = "名称", position = 3)
    private String name;
    /** 标准编码 */
    @ApiModelProperty(value = "标准编码", position = 4)
    private String gbCode;
    /** 显示顺序 */
    @ApiModelProperty(value = "显示顺序", position = 5)
    private Integer displayOrder;
    /** 系统编码 */
    @ApiModelProperty(value = "系统编码", position = 6)
    private String systemCode;
    /** 参数类型名称 */
    @ApiModelProperty(value = "参数类型名称", position = 6)
    private String typeName;

    /** 父名称 */
    @ApiModelProperty(value = "父名称", position = 7)
    private String parentName;
}