package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 异常日志DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "异常日志DTO")
public class LogsExceptionDTO extends BaseDTO {
    /** 日志级别 1紧急 2一般 */
    @ApiModelProperty(value = "日志级别 1紧急 2一般", position = 1)
    private Integer logLevel;
    /** 标题 */
    @ApiModelProperty(value = "标题", position = 2)
    private String shortTitle;
    /** ip */
    @ApiModelProperty(value = "ip", position = 3)
    private String ipAddress;
    /** 操作人Id */
    @ApiModelProperty(value = "操作人Id", position = 4)
    private String customerId;
    /** 操作页面 */
    @ApiModelProperty(value = "操作页面", position = 5)
    private String pageUrl;
    /** 请求地址 */
    @ApiModelProperty(value = "请求地址", position = 6)
    private String requestUrl;
    /** 日志参数 */
    @ApiModelProperty(value = "日志参数", position = 3)
    private String logParam;
    /** 日志内容 */
    @ApiModelProperty(value = "日志内容", position = 7)
    private String message;
}