package com.yiboshi.science.param.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "人才专家分配明细表DTO")
public class ComTalentAssignDTO extends BaseDTO {
    /** 专家Id */
    @ApiModelProperty(value = "专家Id", position = 1)
    @Length(max=36, message = "专家Id不能大于36")
    private String expertId;
    /** 人才Id */
    @ApiModelProperty(value = "人才Id", position = 2)
    @Length(max=36, message = "人才Id不能大于36")
    private String talentId;
    /** 分配年度 */
    @ApiModelProperty(value = "分配年度", position = 3)
    private Integer assignYear;
    /** 审核状态（0 未评审 1 保存 2 已提交） */
    @ApiModelProperty(value = "审核状态（0 未评审 1 保存 2 已提交）", position = 11)
    private Integer auditState;
    /** 总分 */
    @ApiModelProperty(value = "总分", position = 9)
    private BigDecimal totalScore;
    /** 备注 */
    @ApiModelProperty(value = "备注", position =10)
    @Length(max=65535, message = "备注不能大于65535")
    private String remark;


    /** 证件号 */
    @ExcelProperty("证件号")
    @ApiModelProperty(value = "证件号", position = 1)
    private String certId;
    /** 人才姓名 */
    @ExcelProperty("人才姓名")
    @ApiModelProperty(value = "姓名", position = 3)
    private String personName;
    /** 性别 */
    @ApiModelProperty(value = "性别", position = 5)
    private String sex;
    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 16)
    private String mobile;
    /** 人才类别Id */
    @ExcelProperty("人才类别Id")
    @ApiModelProperty(value = "人才类别Id", position = 3)
    private String talentCategory;
    /** 人才类别名称 */
    @ExcelProperty("人才类别名称")
    @ApiModelProperty(value = "人才类别名称", position = 3)
    private String talentCategoryName;
    /** 现从事专业 */
    @ApiModelProperty(value = "现从事专业", position = 11 )
    @Length(max=36, message = "现从事专业不能大于36")
    private String profession;
    /** 现从事专业 */
    @ApiModelProperty(value = "现从事专业", position = 40)
    private String professionName;
    /** 职称 */
    @ApiModelProperty(value = "职称", position = 13)
    private String title;
    /** 职称名称 */
    @ApiModelProperty(value = "职称名称", position = 13)
    private String titleName;
    /** 专业Id */
    @ApiModelProperty(value = "专业Id", position = 5)
    private String spec;
    /** 专业名称 */
    @ApiModelProperty(value = "专业名称", position = 5)
    private String specName;
    /** 申报单位 */
    @ExcelProperty("申报单位")
    @ApiModelProperty(value = "人才类别名称", position = 3)
    private String appUnitName;


    /** 专家证件号 */
    @ExcelProperty("专家证件号")
    @ApiModelProperty(value = "专家证件号", position = 1)
    private String expertCertId;
    /** 专家姓名 */
    @ExcelProperty("专家姓名")
    @ApiModelProperty(value = "专家姓名", position = 3)
    private String expertName;
    /** 专家电话号码 */
    @ApiModelProperty(value = "专家电话号码", position = 10)
    private String expertMobile;
    /** 专家性别 */
    @ApiModelProperty(value = "专家性别", position = 5)
    private String expertSex;
    /** 职称 */
    @ApiModelProperty(value = "职称", position = 13)
    private String expertTitle;
    /** 职称名称 */
    @ApiModelProperty(value = "职称名称", position = 13)
    private String expertTitleName;
    /** 专家所属单位 */
    @ApiModelProperty(value = "专家所属单位", position = 13)
    private String expertUnitName;
    /** 评审专业 */
    @ApiModelProperty(value = "评审专业", position = 13)
    private List<ComExpertSpecDTO> specList;


    /** 评审状态 */
    @ApiModelProperty(value = "评审状态", position =10)
    private String stateName;

    /** 人才分组名称 */
    @ApiModelProperty(value = "人才分组名称", position =10)
    private String groupName;

    /** 评分列表 */
    @ApiModelProperty(value = "评分列表", position = 13)
    private List<ComEvaluationValueDTO> scoreList;
}
