package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 中期考核表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "中期考核表DTO")
public class ComProjectCheckDTO extends BaseDTO {
    /** 考核年度 */
    @ApiModelProperty(value = "考核年度", position = 1 )
    private Integer checkYear;
    /** 项目Id */
    @ApiModelProperty(value = "项目Id", position = 2 )
    @Length(max=36, message = "项目Id不能大于36")
    private String projId;
    /** 阶段性成果其他 */
    @ApiModelProperty(value = "阶段性成果其他", position = 3 )
    @Length(max=800, message = "阶段性成果其他不能大于800")
    private String otherResults;
    /** 研究工作进展 */
    @ApiModelProperty(value = "研究工作进展", position = 4 )
    @Length(max=800, message = "研究工作进展不能大于800")
    private String workProgress;
    /** 项目批准经费 */
    @ApiModelProperty(value = "项目批准经费", position = 5 )
    private BigDecimal applyMoney;
    /** 已使用经费 */
    @ApiModelProperty(value = "已使用经费", position = 6 )
    private BigDecimal usingMoney;
    /** 现结余经费 */
    @ApiModelProperty(value = "现结余经费", position = 7 )
    private BigDecimal surplusMoney;
    /** 经费具体使用情况说明 */
    @ApiModelProperty(value = "经费具体使用情况说明", position = 8 )
    @Length(max=800, message = "经费具体使用情况说明不能大于800")
    private String moneyInstructions;
    /** 上报状态  1 未上报, 5 审核中,10 审核通过,20 审核不通过,30 返回修改 */
    @ApiModelProperty(value = "上报状态  1 未上报, 5 审核中,10 审核通过,20 审核不通过,30 返回修改", position = 9 )
    private Integer checkState;

    /** 上报状态 */
    @ApiModelProperty(value = "上报状态", position = 10)
    private String checkStateName;
    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 11 )
    private String projName;
    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 12 )
    @Length(max=100, message = "项目编号不能大于100")
    private String projNo;
    /** 项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项 */
    @ApiModelProperty(value = "项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项", position = 7)
    private Integer projState;
    /** 项目状态 */
    @ApiModelProperty(value = "项目状态", position = 13)
    private String projStateName;
    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 14)
    private String appPersonName;
    /** 单位 */
    @ApiModelProperty(value = "单位", position = 15)
    private String appUnitName;
    /** 项目开始时间 */
    @ApiModelProperty(value = "项目开始时间", position = 16 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /** 项目结束时间 */
    @ApiModelProperty(value = "项目结束时间", position = 17 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
    /** 阶段性成果 */
    @ApiModelProperty(value = "项目结束时间", position = 18 )
    List<String> results;
    /** 审核列表 */
    @ApiModelProperty(value = "项目结束时间", position = 19 )
    private List<ComProjectAuditNoteDTO> auditList;

}