package com.yiboshi.science.param.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import com.yiboshi.science.entity.AssignCount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "专家表DTO")
public class ComExpertDTO extends BaseDTO {
    /** 人员Id */
    @ApiModelProperty(value = "人员Id", position = 2)
    @Length(max=36, message = "人员Id不能大于36")
    private String personId;
    /** 专家状态  1 启用  2 停用 */
    @ApiModelProperty(value = "专家状态  1 启用  2 停用", position = 3 )
    private Integer expertState;
    /** 上报状态  1 未上报  2 已上报 */
    @ApiModelProperty(value = "上报状态  1 未上报  2 已上报", position = 7 )
    private Integer reportState;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 19 )
    @Length(max=200, message = "备注不能大于200")
    private String remark;

    /** 专家状态  1 启用  2 停用 */
    @ApiModelProperty(value = "专家状态  1 启用  2 停用", position = 4 )
    private String expertStateName;
    /** 姓名 */
    @ExcelProperty("姓名")
    @ApiModelProperty(value = "姓名", position = 6)
    private String personName;
    /** 证件号 */
    @ExcelProperty("证件号")
    @ApiModelProperty(value = "证件号", position = 5)
    @Length(max=18, message = "证件号不能大于18")
    private String certId;
    /** 性别 */
    @ExcelProperty("性别")
    @ApiModelProperty(value = "性别", position = 7)
    private String sex;
    /** 出生日期 */
    @ApiModelProperty(value = "出生日期", position = 8)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;
    /** 职称Id */
    @ApiModelProperty(value = "职称Id", position = 9)
    @Length(max=36, message = "职称Id不能大于36")
    private String title;
    /** 职称 */
    @ExcelProperty("职称")
    @ApiModelProperty(value = "职称", position = 10)
    private String titleName;
    /** 专业Id */
    @ApiModelProperty(value = "专业Id", position = 11)
    @Length(max=36, message = "专业Id不能大于36")
    private String spec;
    /** 专业 */
    @ExcelProperty("专业")
    @ApiModelProperty(value = "专业", position = 12)
    private String specName;
    /** 学位Id */
    @ApiModelProperty(value = "学位Id", position = 13 )
    @Length(max=36, message = "学位Id不能大于36")
    private String degree;
    /** 学位 */
    @ApiModelProperty(value = "学位", position = 14)
    private String degreeName;
    /** 学历 */
    @ApiModelProperty(value = "学历", position = 10)
    private String education;
    /** 学历 */
    @ApiModelProperty(value = "学历", position = 35)
    private String educationName;
    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", position = 15)
    private String email;
    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 16)
    private String mobile;
    /** 照片Id */
    @ApiModelProperty(value = "照片Id", position = 17)
    @Length(max=36, message = "照片Id不能大于36")
    private String photo;
    /** 住址 */
    @ApiModelProperty(value = "住址", position = 18)
    private String address;

    /** 单位 */
    @ApiModelProperty(value = "单位", position = 20)
    private String unitName;
    /** 单位Id */
    @ApiModelProperty(value = "单位Id", position = 19)
    @Length(max=36, message = "单位Id不能大于36")
    private String unitId;
    /** 单位编码 */
    @ApiModelProperty(value = "单位编码", position = 7)
    private String treeCode;
    /** 工作单位 */
    @ApiModelProperty(value = "工作单位", position = 21)
    private String workUnit;
    /** 项目分配信息 */
    @ApiModelProperty(value = "项目分配信息", position = 23)
    private List<AssignCount> assignInfo;
    /** 评审专业 */
    @ApiModelProperty(value = "评审专业", position = 25)
    private List<ComExpertSpecDTO> specList;
    /** 用户Id*/
    @ApiModelProperty(value = "用户Id", position = 30)
    private String userId;
    /** 用户名 */
    @ApiModelProperty(value = "用户名", position = 22)
    private String username;
    /** 密码 */
    @ApiModelProperty(value = "密码", position = 22)
    private String password;
    /** 用户角色Id*/
    @ApiModelProperty(value = "用户角色Id", position = 30)
    private String userRoleId;
    /** 角色Id */
    @ApiModelProperty(value = "角色Id", position = 7)
    private String roleId;
    /** 用户角色状态*/
    @ApiModelProperty(value = "用户角色状态", position = 30)
    private Integer state;
    /** 用户角色状态*/
    @ApiModelProperty(value = "用户角色状态", position = 30)
    private String stateName;
    /** 是否财务专家 */
    @ApiModelProperty(value = "是否财务专家", position = 30)
    private Integer isFinance;
    /** 年度 */
    @ApiModelProperty(value = "年度", position = 30)
    private Integer groupYear;
    /** 评审项目数 */
    @ApiModelProperty(value = "评审项目数", position = 30)
    private Integer projectCount;
}
