package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 *  验收材料目录表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "验收材料目录表DTO")
public class ComConclusionCatalogDTO extends BaseDTO {
    /** 结题信息表id */
    @ApiModelProperty(value = "结题信息表id", position = 1)
    @Length(max=36, message = "结题信息表id不能大于36")
    private String conclusionId;
    /** 材料名称 */
    @ApiModelProperty(value = "材料名称", position = 2)
    @Length(max=36, message = "材料名称大于100")
    private String name;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 19 )
    @Length(max=200, message = "备注不能大于200")
    private String remark;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 10 )
    private Integer showIndex;
}