package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * 菜单表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "菜单表VO")
public class SystemMenu extends BaseEntity {
    /** 菜单名称 */
    @ApiModelProperty(value = "菜单名称", position = 2 , required = true)
    @NotNull(message = "菜单名称不能为空")
    @Length(max=200, message = "菜单名称不能大于200")
    private String menuName;
    /** 访问Url */
    @ApiModelProperty(value = "访问Url", position = 3 )
    @Length(max=200, message = "访问Url不能大于200")
    private String actionUrl;
    /** 图标 */
    @ApiModelProperty(value = "图标", position = 2 )
    @Length(max=200, message = "图标")
    private String icon;
    /** 窗口参数 */
    @ApiModelProperty(value = "窗口参数", position = 4 )
    @Length(max=200, message = "窗口参数不能大于200")
    private String windowPara;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 5 )
    private Integer showIndex;
    /** 父Id */
    @ApiModelProperty(value = "父Id", position = 6 )
    private String parentId;

    /** 是否缓存  1是 ,0否*/
    @ApiModelProperty(value = "是否缓存", position = 5 )
    private Integer keepAlive;

}